/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.7.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.user.factor;

import com.okta.sdk.resource.user.factor.ActivateFactorRequest;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * UserFactor
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2021-10-11T13:51:40.379-05:00")
public interface UserFactor extends ExtensibleResource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    Date getCreated();

    FactorType getFactorType();

    UserFactor setFactorType(FactorType factorType);

    String getId();

    Date getLastUpdated();

    FactorProvider getProvider();

    UserFactor setProvider(FactorProvider provider);

    FactorStatus getStatus();

    VerifyFactorRequest getVerify();

    UserFactor setVerify(VerifyFactorRequest verify);


    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    void delete();


    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process.
    * @param body  (optional)
    * @return UserFactor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    UserFactor activate(ActivateFactorRequest body);

    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process.
    * @return UserFactor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    UserFactor activate();

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (optional)
    * @param templateId  (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @param xForwardedFor  (optional)
    * @param userAgent  (optional)
    * @param acceptLanguage  (optional)
    * @return VerifyUserFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyUserFactorResponse verify(VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage);

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @return VerifyUserFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyUserFactorResponse verify();

}

