/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.7.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.inline.hook;

import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookChannel;
import com.okta.sdk.resource.inline.hook.InlineHookPayload;
import com.okta.sdk.resource.inline.hook.InlineHookResponse;
import com.okta.sdk.resource.inline.hook.InlineHookStatus;
import com.okta.sdk.resource.inline.hook.InlineHookType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * InlineHook
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2021-10-11T13:51:40.379-05:00")
public interface InlineHook extends ExtensibleResource, Deletable {

    Map<String, Object> getLinks();

    InlineHookChannel getChannel();

    InlineHook setChannel(InlineHookChannel channel);

    Date getCreated();

    String getId();

    Date getLastUpdated();

    String getName();

    InlineHook setName(String name);

    InlineHookStatus getStatus();

    InlineHook setStatus(InlineHookStatus status);

    InlineHookType getType();

    InlineHook setType(InlineHookType type);

    String getVersion();

    InlineHook setVersion(String version);


    /**
    * 
    * Updates an inline hook by ID
    * @return InlineHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "PUT - /api/v1/inlineHooks/{inlineHookId}")
    InlineHook update();


    /**
    * 
    * Executes the Inline Hook matching the provided inlineHookId using the request body as the input. This will send the provided data through the Channel and return a response if it matches the correct data contract. This execution endpoint should only be used for testing purposes.
    * @param payloadData  (required)
    * @return InlineHookResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/inlineHooks/{inlineHookId}/execute")
    InlineHookResponse execute(InlineHookPayload payloadData);


    /**
    * 
    * Deletes the Inline Hook matching the provided id. Once deleted, the Inline Hook is unrecoverable. As a safety precaution, only Inline Hooks with a status of INACTIVE are eligible for deletion.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "DELETE - /api/v1/inlineHooks/{inlineHookId}")
    void delete();


    /**
    * 
    * Deactivates the Inline Hook matching the provided id
    * @return InlineHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/inlineHooks/{inlineHookId}/lifecycle/deactivate")
    InlineHook deactivate();


    /**
    * 
    * Activates the Inline Hook matching the provided id
    * @return InlineHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-10-11T13:51:40.379-05:00",
            comments = "POST - /api/v1/inlineHooks/{inlineHookId}/lifecycle/activate")
    InlineHook activate();


}

