/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Activates a `webauthn` factor with the specified attestation and registration information from the WebAuthn authenticator")
@JsonPropertyOrder(value={"attestation", "clientData"})
@JsonTypeName(value="webauthn")
public class Webauthn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ATTESTATION = "attestation";
    private String attestation;
    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;

    public Webauthn attestation(String attestation) {
        this.attestation = attestation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="o2NmbXRmcGFja2VkZ2F0dFN0bXSiY2FsZyZjc2lnWEgwRgIhAMvf2+dzXlHZN1um38Y8aFzrKvX0k5dt/hnDu9lahbR4AiEAuwtMg3IoaElWMp00QrP/+3Po/6LwXfmYQVfsnsQ+da1oYXV0aERhdGFYxkgb9OHGifjS2dG03qLRqvXrDIRyfGAuc+GzF1z20/eVRV2wvl6tzgACNbzGCmSLCyXx8FUDAEIBvWNHOcE3QDUkDP/HB1kRbrIOoZ1dR874ZaGbMuvaSVHVWN2kfNiO4D+HlAzUEFaqlNi5FPqKw+mF8f0XwdpEBlClAQIDJiABIVgg0a6oo3W0JdYPu6+eBrbr0WyB3uJLI3ODVgDfQnpgafgiWCB4fFo/5iiVrFhB8pNH2tbBtKewyAHuDkRolcCnVaCcmQ==", value="Base64-encoded attestation from the WebAuthn authenticator")
    @JsonProperty(value="attestation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttestation() {
        return this.attestation;
    }

    @JsonProperty(value="attestation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttestation(String attestation) {
        this.attestation = attestation;
    }

    public Webauthn clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJjaGFsbGVuZ2UiOiJVSk5wYW9sVWt0dF9vcEZPNXJMYyIsIm9yaWdpbiI6Imh0dHBzOi8vcmFpbi5va3RhMS5jb20iLCJ0eXBlIjoid2ViYXV0aG4uY3JlYXRlIn0", value="Base64-encoded client data from the WebAuthn authenticator")
    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientData() {
        return this.clientData;
    }

    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webauthn webauthn = (Webauthn)o;
        return Objects.equals(this.attestation, webauthn.attestation) && Objects.equals(this.clientData, webauthn.clientData);
    }

    public int hashCode() {
        return Objects.hash(this.attestation, this.clientData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webauthn {\n");
        sb.append("    attestation: ").append(this.toIndentedString(this.attestation)).append("\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

