/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.HrefObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies link relations (see [Web Linking](https://datatracker.ietf.org/doc/html/rfc8288) available for the current status of a user. The links object is used for dynamic discovery of related resources, lifecycle operations, and credential operations. The links object is read-only.  For an individual user result, the links object contains a full set of link relations available for that user as determined by your policies. For a collection of users, the links object contains only the `self` link. Operations that return a collection of users include [List all users](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers) and [List all group member users](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroupUsers).")
@JsonPropertyOrder(value={"self", "activate", "resetPassword", "resetFactors", "expirePassword", "forgotPassword", "changeRecoveryQuestion", "deactivate", "reactivate", "changePassword", "schema", "suspend", "unsuspend", "unlock", "type"})
@JsonTypeName(value="User__links")
public class UserLinks
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObject self;
    public static final String JSON_PROPERTY_ACTIVATE = "activate";
    private HrefObject activate;
    public static final String JSON_PROPERTY_RESET_PASSWORD = "resetPassword";
    private HrefObject resetPassword;
    public static final String JSON_PROPERTY_RESET_FACTORS = "resetFactors";
    private HrefObject resetFactors;
    public static final String JSON_PROPERTY_EXPIRE_PASSWORD = "expirePassword";
    private HrefObject expirePassword;
    public static final String JSON_PROPERTY_FORGOT_PASSWORD = "forgotPassword";
    private HrefObject forgotPassword;
    public static final String JSON_PROPERTY_CHANGE_RECOVERY_QUESTION = "changeRecoveryQuestion";
    private HrefObject changeRecoveryQuestion;
    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private HrefObject deactivate;
    public static final String JSON_PROPERTY_REACTIVATE = "reactivate";
    private HrefObject reactivate;
    public static final String JSON_PROPERTY_CHANGE_PASSWORD = "changePassword";
    private HrefObject changePassword;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private HrefObject schema;
    public static final String JSON_PROPERTY_SUSPEND = "suspend";
    private HrefObject suspend;
    public static final String JSON_PROPERTY_UNSUSPEND = "unsuspend";
    private HrefObject unsuspend;
    public static final String JSON_PROPERTY_UNLOCK = "unlock";
    private HrefObject unlock;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HrefObject type;

    public UserLinks self(HrefObject self) {
        this.self = self;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the individual user")
    @JsonProperty(value="self")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getSelf() {
        return this.self;
    }

    @JsonProperty(value="self")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObject self) {
        this.self = self;
    }

    public UserLinks activate(HrefObject activate) {
        this.activate = activate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to activate the user")
    @JsonProperty(value="activate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getActivate() {
        return this.activate;
    }

    @JsonProperty(value="activate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivate(HrefObject activate) {
        this.activate = activate;
    }

    public UserLinks resetPassword(HrefObject resetPassword) {
        this.resetPassword = resetPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to reset the user's password")
    @JsonProperty(value="resetPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getResetPassword() {
        return this.resetPassword;
    }

    @JsonProperty(value="resetPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResetPassword(HrefObject resetPassword) {
        this.resetPassword = resetPassword;
    }

    public UserLinks resetFactors(HrefObject resetFactors) {
        this.resetFactors = resetFactors;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to reset the user's factors")
    @JsonProperty(value="resetFactors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getResetFactors() {
        return this.resetFactors;
    }

    @JsonProperty(value="resetFactors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResetFactors(HrefObject resetFactors) {
        this.resetFactors = resetFactors;
    }

    public UserLinks expirePassword(HrefObject expirePassword) {
        this.expirePassword = expirePassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to expire the user's password")
    @JsonProperty(value="expirePassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getExpirePassword() {
        return this.expirePassword;
    }

    @JsonProperty(value="expirePassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpirePassword(HrefObject expirePassword) {
        this.expirePassword = expirePassword;
    }

    public UserLinks forgotPassword(HrefObject forgotPassword) {
        this.forgotPassword = forgotPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to initiate a forgot password operation")
    @JsonProperty(value="forgotPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getForgotPassword() {
        return this.forgotPassword;
    }

    @JsonProperty(value="forgotPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForgotPassword(HrefObject forgotPassword) {
        this.forgotPassword = forgotPassword;
    }

    public UserLinks changeRecoveryQuestion(HrefObject changeRecoveryQuestion) {
        this.changeRecoveryQuestion = changeRecoveryQuestion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to change the user's recovery question")
    @JsonProperty(value="changeRecoveryQuestion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getChangeRecoveryQuestion() {
        return this.changeRecoveryQuestion;
    }

    @JsonProperty(value="changeRecoveryQuestion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeRecoveryQuestion(HrefObject changeRecoveryQuestion) {
        this.changeRecoveryQuestion = changeRecoveryQuestion;
    }

    public UserLinks deactivate(HrefObject deactivate) {
        this.deactivate = deactivate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to deactivate a user")
    @JsonProperty(value="deactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getDeactivate() {
        return this.deactivate;
    }

    @JsonProperty(value="deactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(HrefObject deactivate) {
        this.deactivate = deactivate;
    }

    public UserLinks reactivate(HrefObject reactivate) {
        this.reactivate = reactivate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to reactivate the user")
    @JsonProperty(value="reactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getReactivate() {
        return this.reactivate;
    }

    @JsonProperty(value="reactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReactivate(HrefObject reactivate) {
        this.reactivate = reactivate;
    }

    public UserLinks changePassword(HrefObject changePassword) {
        this.changePassword = changePassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to change the user's password")
    @JsonProperty(value="changePassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getChangePassword() {
        return this.changePassword;
    }

    @JsonProperty(value="changePassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangePassword(HrefObject changePassword) {
        this.changePassword = changePassword;
    }

    public UserLinks schema(HrefObject schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the user's profile schema")
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(HrefObject schema) {
        this.schema = schema;
    }

    public UserLinks suspend(HrefObject suspend) {
        this.suspend = suspend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to suspend the user")
    @JsonProperty(value="suspend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getSuspend() {
        return this.suspend;
    }

    @JsonProperty(value="suspend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuspend(HrefObject suspend) {
        this.suspend = suspend;
    }

    public UserLinks unsuspend(HrefObject unsuspend) {
        this.unsuspend = unsuspend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to unsuspend the user")
    @JsonProperty(value="unsuspend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getUnsuspend() {
        return this.unsuspend;
    }

    @JsonProperty(value="unsuspend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnsuspend(HrefObject unsuspend) {
        this.unsuspend = unsuspend;
    }

    public UserLinks unlock(HrefObject unlock) {
        this.unlock = unlock;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to unlock the locked-out user")
    @JsonProperty(value="unlock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getUnlock() {
        return this.unlock;
    }

    @JsonProperty(value="unlock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnlock(HrefObject unlock) {
        this.unlock = unlock;
    }

    public UserLinks type(HrefObject type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the user type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(HrefObject type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserLinks userLinks = (UserLinks)o;
        return Objects.equals(this.self, userLinks.self) && Objects.equals(this.activate, userLinks.activate) && Objects.equals(this.resetPassword, userLinks.resetPassword) && Objects.equals(this.resetFactors, userLinks.resetFactors) && Objects.equals(this.expirePassword, userLinks.expirePassword) && Objects.equals(this.forgotPassword, userLinks.forgotPassword) && Objects.equals(this.changeRecoveryQuestion, userLinks.changeRecoveryQuestion) && Objects.equals(this.deactivate, userLinks.deactivate) && Objects.equals(this.reactivate, userLinks.reactivate) && Objects.equals(this.changePassword, userLinks.changePassword) && Objects.equals(this.schema, userLinks.schema) && Objects.equals(this.suspend, userLinks.suspend) && Objects.equals(this.unsuspend, userLinks.unsuspend) && Objects.equals(this.unlock, userLinks.unlock) && Objects.equals(this.type, userLinks.type);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.activate, this.resetPassword, this.resetFactors, this.expirePassword, this.forgotPassword, this.changeRecoveryQuestion, this.deactivate, this.reactivate, this.changePassword, this.schema, this.suspend, this.unsuspend, this.unlock, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserLinks {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    activate: ").append(this.toIndentedString(this.activate)).append("\n");
        sb.append("    resetPassword: ").append(this.toIndentedString(this.resetPassword)).append("\n");
        sb.append("    resetFactors: ").append(this.toIndentedString(this.resetFactors)).append("\n");
        sb.append("    expirePassword: ").append(this.toIndentedString(this.expirePassword)).append("\n");
        sb.append("    forgotPassword: ").append(this.toIndentedString(this.forgotPassword)).append("\n");
        sb.append("    changeRecoveryQuestion: ").append(this.toIndentedString(this.changeRecoveryQuestion)).append("\n");
        sb.append("    deactivate: ").append(this.toIndentedString(this.deactivate)).append("\n");
        sb.append("    reactivate: ").append(this.toIndentedString(this.reactivate)).append("\n");
        sb.append("    changePassword: ").append(this.toIndentedString(this.changePassword)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    suspend: ").append(this.toIndentedString(this.suspend)).append("\n");
        sb.append("    unsuspend: ").append(this.toIndentedString(this.unsuspend)).append("\n");
        sb.append("    unlock: ").append(this.toIndentedString(this.unlock)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

