/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"credentialId", "deviceToken", "deviceType", "name", "platform", "version"})
public class UserFactorPushProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIAL_ID = "credentialId";
    private String credentialId;
    public static final String JSON_PROPERTY_DEVICE_TOKEN = "deviceToken";
    private String deviceToken;
    public static final String JSON_PROPERTY_DEVICE_TYPE = "deviceType";
    private String deviceType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private String platform;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public UserFactorPushProfile credentialId(String credentialId) {
        this.credentialId = credentialId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="dade.murphy@example.com", value="ID for the factor credential")
    @JsonProperty(value="credentialId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCredentialId() {
        return this.credentialId;
    }

    @JsonProperty(value="credentialId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public UserFactorPushProfile deviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="fwf7ku6bsiSCieh6y1d7", value="Token used to identify the device")
    @JsonProperty(value="deviceToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceToken() {
        return this.deviceToken;
    }

    @JsonProperty(value="deviceToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public UserFactorPushProfile deviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SmartPhone_IPhone", value="Type of device")
    @JsonProperty(value="deviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceType() {
        return this.deviceType;
    }

    @JsonProperty(value="deviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public UserFactorPushProfile name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My Phone", value="Name of the device")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public UserFactorPushProfile platform(String platform) {
        this.platform = platform;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IOS", value="OS version of the associated device")
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlatform() {
        return this.platform;
    }

    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public UserFactorPushProfile version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9.0", value="Installed version of Okta Verify")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorPushProfile userFactorPushProfile = (UserFactorPushProfile)o;
        return Objects.equals(this.credentialId, userFactorPushProfile.credentialId) && Objects.equals(this.deviceToken, userFactorPushProfile.deviceToken) && Objects.equals(this.deviceType, userFactorPushProfile.deviceType) && Objects.equals(this.name, userFactorPushProfile.name) && Objects.equals(this.platform, userFactorPushProfile.platform) && Objects.equals(this.version, userFactorPushProfile.version);
    }

    public int hashCode() {
        return Objects.hash(this.credentialId, this.deviceToken, this.deviceType, this.name, this.platform, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorPushProfile {\n");
        sb.append("    credentialId: ").append(this.toIndentedString(this.credentialId)).append("\n");
        sb.append("    deviceToken: ").append(this.toIndentedString(this.deviceToken)).append("\n");
        sb.append("    deviceType: ").append(this.toIndentedString(this.deviceType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

