/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GrantType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details of the token request")
@JsonPropertyOrder(value={"client_id", "grant_type", "redirect_uri", "response_mode", "response_type", "scope", "state"})
public class TokenProtocolRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_GRANT_TYPE = "grant_type";
    private GrantType grantType;
    public static final String JSON_PROPERTY_REDIRECT_URI = "redirect_uri";
    private URI redirectUri;
    public static final String JSON_PROPERTY_RESPONSE_MODE = "response_mode";
    private ResponseModeEnum responseMode;
    public static final String JSON_PROPERTY_RESPONSE_TYPE = "response_type";
    private ResponseTypeEnum responseType;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public TokenProtocolRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the client associated with the token")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TokenProtocolRequest grantType(GrantType grantType) {
        this.grantType = grantType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="grant_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GrantType getGrantType() {
        return this.grantType;
    }

    @JsonProperty(value="grant_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public TokenProtocolRequest redirectUri(URI redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the callback location where the authorization was sent")
    @JsonProperty(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getRedirectUri() {
        return this.redirectUri;
    }

    @JsonProperty(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUri(URI redirectUri) {
        this.redirectUri = redirectUri;
    }

    public TokenProtocolRequest responseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authorization response mode")
    @JsonProperty(value="response_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseModeEnum getResponseMode() {
        return this.responseMode;
    }

    @JsonProperty(value="response_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
    }

    public TokenProtocolRequest responseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authorization response type")
    @JsonProperty(value="response_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseTypeEnum getResponseType() {
        return this.responseType;
    }

    @JsonProperty(value="response_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    public TokenProtocolRequest scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scopes requested")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public TokenProtocolRequest state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenProtocolRequest tokenProtocolRequest = (TokenProtocolRequest)o;
        return Objects.equals(this.clientId, tokenProtocolRequest.clientId) && Objects.equals((Object)this.grantType, (Object)tokenProtocolRequest.grantType) && Objects.equals(this.redirectUri, tokenProtocolRequest.redirectUri) && Objects.equals((Object)this.responseMode, (Object)tokenProtocolRequest.responseMode) && Objects.equals((Object)this.responseType, (Object)tokenProtocolRequest.responseType) && Objects.equals(this.scope, tokenProtocolRequest.scope) && Objects.equals(this.state, tokenProtocolRequest.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.grantType, this.redirectUri, this.responseMode, this.responseType, this.scope, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenProtocolRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    grantType: ").append(this.toIndentedString((Object)this.grantType)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    responseMode: ").append(this.toIndentedString((Object)this.responseMode)).append("\n");
        sb.append("    responseType: ").append(this.toIndentedString((Object)this.responseType)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResponseModeEnum {
        FORM_POST(String.valueOf("form_post")),
        FRAGMENT(String.valueOf("fragment")),
        OKTA_POST_MESSAGE(String.valueOf("okta_post_message")),
        QUERY(String.valueOf("query")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ResponseModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResponseModeEnum fromValue(String value) {
            for (ResponseModeEnum b : ResponseModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ResponseTypeEnum {
        CODE(String.valueOf("code")),
        ID_TOKEN(String.valueOf("id_token")),
        TOKEN(String.valueOf("token")),
        NONE(String.valueOf("none")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ResponseTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResponseTypeEnum fromValue(String value) {
            for (ResponseTypeEnum b : ResponseTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

