/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.TokenHookResponseCommandsInner;
import com.okta.sdk.resource.model.TokenHookResponseError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="For the token inline hook, the `commands` and `error` objects that you can return in the JSON payload of your response are defined in the following sections. > **Note:** The size of your response payload must be less than 256 KB.")
@JsonPropertyOrder(value={"commands", "error"})
public class TokenHookResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private List<TokenHookResponseCommandsInner> commands = null;
    public static final String JSON_PROPERTY_ERROR = "error";
    private TokenHookResponseError error;

    public TokenHookResponse commands(List<TokenHookResponseCommandsInner> commands) {
        this.commands = commands;
        return this;
    }

    public TokenHookResponse addcommandsItem(TokenHookResponseCommandsInner commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<TokenHookResponseCommandsInner>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="You can use the `commands` object to provide commands to Okta. It's where you can tell Okta to add more claims to the token. The `commands` object is an array, allowing you to send multiple commands. In each array element, there needs to be a `type` property and `value` property. The `type` property is where you specify which of the supported commands you want to execute, and `value` is where you supply an operand for that command. In the case of the token hook type, the `value` property is itself a nested object in which you specify a particular operation, a path to act on, and a value.")
    @JsonProperty(value="commands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TokenHookResponseCommandsInner> getCommands() {
        return this.commands;
    }

    @JsonProperty(value="commands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommands(List<TokenHookResponseCommandsInner> commands) {
        this.commands = commands;
    }

    public TokenHookResponse error(TokenHookResponseError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenHookResponseError getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(TokenHookResponseError error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenHookResponse tokenHookResponse = (TokenHookResponse)o;
        return Objects.equals(this.commands, tokenHookResponse.commands) && Objects.equals(this.error, tokenHookResponse.error);
    }

    public int hashCode() {
        return Objects.hash(this.commands, this.error);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenHookResponse {\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

