/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"endpoint", "subjectFormat", "authMethod", "partialLogout"})
@JsonTypeName(value="SubmissionResponse_globalTokenRevocation")
public class SubmissionResponseGlobalTokenRevocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ENDPOINT = "endpoint";
    private URI endpoint;
    public static final String JSON_PROPERTY_SUBJECT_FORMAT = "subjectFormat";
    private SubjectFormatEnum subjectFormat;
    public static final String JSON_PROPERTY_AUTH_METHOD = "authMethod";
    private AuthMethodEnum authMethod;
    public static final String JSON_PROPERTY_PARTIAL_LOGOUT = "partialLogout";
    private Boolean partialLogout = false;

    public SubmissionResponseGlobalTokenRevocation endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="URL of the authorization server's global token revocation endpoint")
    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public SubmissionResponseGlobalTokenRevocation subjectFormat(SubjectFormatEnum subjectFormat) {
        this.subjectFormat = subjectFormat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The format of the subject")
    @JsonProperty(value="subjectFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SubjectFormatEnum getSubjectFormat() {
        return this.subjectFormat;
    }

    @JsonProperty(value="subjectFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjectFormat(SubjectFormatEnum subjectFormat) {
        this.subjectFormat = subjectFormat;
    }

    public SubmissionResponseGlobalTokenRevocation authMethod(AuthMethodEnum authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Authentication method <br> **Note:** Currently, only the `SIGNED_JWT` method is supported.")
    @JsonProperty(value="authMethod")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AuthMethodEnum getAuthMethod() {
        return this.authMethod;
    }

    @JsonProperty(value="authMethod")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthMethod(AuthMethodEnum authMethod) {
        this.authMethod = authMethod;
    }

    public SubmissionResponseGlobalTokenRevocation partialLogout(Boolean partialLogout) {
        this.partialLogout = partialLogout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow partial support for Universal Logout")
    @JsonProperty(value="partialLogout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPartialLogout() {
        return this.partialLogout;
    }

    @JsonProperty(value="partialLogout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartialLogout(Boolean partialLogout) {
        this.partialLogout = partialLogout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmissionResponseGlobalTokenRevocation submissionResponseGlobalTokenRevocation = (SubmissionResponseGlobalTokenRevocation)o;
        return Objects.equals(this.endpoint, submissionResponseGlobalTokenRevocation.endpoint) && Objects.equals((Object)this.subjectFormat, (Object)submissionResponseGlobalTokenRevocation.subjectFormat) && Objects.equals((Object)this.authMethod, (Object)submissionResponseGlobalTokenRevocation.authMethod) && Objects.equals(this.partialLogout, submissionResponseGlobalTokenRevocation.partialLogout);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endpoint, this.subjectFormat, this.authMethod, this.partialLogout});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmissionResponseGlobalTokenRevocation {\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    subjectFormat: ").append(this.toIndentedString((Object)this.subjectFormat)).append("\n");
        sb.append("    authMethod: ").append(this.toIndentedString((Object)this.authMethod)).append("\n");
        sb.append("    partialLogout: ").append(this.toIndentedString(this.partialLogout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubjectFormatEnum {
        EMAIL(String.valueOf("EMAIL")),
        ISS_SUB(String.valueOf("ISS_SUB")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private SubjectFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubjectFormatEnum fromValue(String value) {
            for (SubjectFormatEnum b : SubjectFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum AuthMethodEnum {
        SIGNED_JWT(String.valueOf("SIGNED_JWT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private AuthMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthMethodEnum fromValue(String value) {
            for (AuthMethodEnum b : AuthMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

