/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"state", "stream_id"})
public class StreamVerificationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_STREAM_ID = "stream_id";
    private String streamId;

    public StreamVerificationRequest state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="VGhpcyBpcyBhbiBleGFtcGxlIHN0YXRlIHZhbHVlLgo=", value="An arbitrary string that Okta as a transmitter must echo back to the Event Receiver in the Verification Event's payload")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public StreamVerificationRequest streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="esc1k235GIIztAuGK0g5", required=true, value="The ID of the SSF Stream Configuration")
    @JsonProperty(value="stream_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStreamId() {
        return this.streamId;
    }

    @JsonProperty(value="stream_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamVerificationRequest streamVerificationRequest = (StreamVerificationRequest)o;
        return Objects.equals(this.state, streamVerificationRequest.state) && Objects.equals(this.streamId, streamVerificationRequest.streamId);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.streamId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamVerificationRequest {\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

