/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The social authentication token object provides the tokens and associated metadata provided by social providers during social authentication.")
@JsonPropertyOrder(value={"expiresAt", "id", "scopes", "token", "tokenAuthScheme", "tokenType"})
public class SocialAuthToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_TOKEN_AUTH_SCHEME = "tokenAuthScheme";
    private String tokenAuthScheme;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
    private String tokenType;

    @Nullable
    @ApiModelProperty(example="2016-01-03T18:15:47Z", value="Timestamp when the object expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    @ApiModelProperty(example="NXp9GaX1eOA-XVF_H9fn2Q", value="Unique identifier for the token")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="[\"openid\",\"foo\"]", value="The scopes that the token is good for")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @Nullable
    @ApiModelProperty(example="JBTWGV22G4ZGKV3N", value="The raw token")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @Nullable
    @ApiModelProperty(example="Bearer", value="The token authentication scheme as defined by the social provider")
    @JsonProperty(value="tokenAuthScheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenAuthScheme() {
        return this.tokenAuthScheme;
    }

    @Nullable
    @ApiModelProperty(example="urn:ietf:params:oauth:token-type:access_token", value="The type of token defined by the [OAuth Token Exchange Spec](https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-07#section-3)")
    @JsonProperty(value="tokenType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenType() {
        return this.tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialAuthToken socialAuthToken = (SocialAuthToken)o;
        return Objects.equals(this.expiresAt, socialAuthToken.expiresAt) && Objects.equals(this.id, socialAuthToken.id) && Objects.equals(this.scopes, socialAuthToken.scopes) && Objects.equals(this.token, socialAuthToken.token) && Objects.equals(this.tokenAuthScheme, socialAuthToken.tokenAuthScheme) && Objects.equals(this.tokenType, socialAuthToken.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.expiresAt, this.id, this.scopes, this.token, this.tokenAuthScheme, this.tokenType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SocialAuthToken {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenAuthScheme: ").append(this.toIndentedString(this.tokenAuthScheme)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

