/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.OktaUserServiceAccountCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Details for managing an Okta user as a service account")
@JsonPropertyOrder(value={"credentials", "email", "oktaUserId"})
public class ServiceAccountDetailsOktaUserAccountSub
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private OktaUserServiceAccountCredentials credentials;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_OKTA_USER_ID = "oktaUserId";
    private String oktaUserId;

    public ServiceAccountDetailsOktaUserAccountSub credentials(OktaUserServiceAccountCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OktaUserServiceAccountCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(OktaUserServiceAccountCredentials credentials) {
        this.credentials = credentials;
    }

    @Nullable
    @ApiModelProperty(example="foo@bar.com", value="The email address for the Okta user")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    public ServiceAccountDetailsOktaUserAccountSub oktaUserId(String oktaUserId) {
        this.oktaUserId = oktaUserId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="00u11s48P9zGW8yqm0g5", required=true, value="The ID of the Okta user to manage as a service account")
    @JsonProperty(value="oktaUserId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOktaUserId() {
        return this.oktaUserId;
    }

    @JsonProperty(value="oktaUserId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOktaUserId(String oktaUserId) {
        this.oktaUserId = oktaUserId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountDetailsOktaUserAccountSub serviceAccountDetailsOktaUserAccountSub = (ServiceAccountDetailsOktaUserAccountSub)o;
        return Objects.equals(this.credentials, serviceAccountDetailsOktaUserAccountSub.credentials) && Objects.equals(this.email, serviceAccountDetailsOktaUserAccountSub.email) && Objects.equals(this.oktaUserId, serviceAccountDetailsOktaUserAccountSub.oktaUserId);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.email, this.oktaUserId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceAccountDetailsOktaUserAccountSub {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    oktaUserId: ").append(this.toIndentedString(this.oktaUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

