/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AppServiceAccountCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Details for a SaaS app account, which will be managed as a service account")
@JsonPropertyOrder(value={"appGlobalName", "appInstanceName", "credentials", "oktaApplicationId"})
public class ServiceAccountDetailsAppAccountSub
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_GLOBAL_NAME = "appGlobalName";
    private String appGlobalName;
    public static final String JSON_PROPERTY_APP_INSTANCE_NAME = "appInstanceName";
    private String appInstanceName;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private AppServiceAccountCredentials credentials;
    public static final String JSON_PROPERTY_OKTA_APPLICATION_ID = "oktaApplicationId";
    private String oktaApplicationId;

    @Nullable
    @ApiModelProperty(example="Salesforce", value="The name of the SaaS app in the Okta Integration Network catalog")
    @JsonProperty(value="appGlobalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppGlobalName() {
        return this.appGlobalName;
    }

    @Nullable
    @ApiModelProperty(example="Salesforce Prod", value="The instance name of the SaaS app")
    @JsonProperty(value="appInstanceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    public ServiceAccountDetailsAppAccountSub credentials(AppServiceAccountCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AppServiceAccountCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentials(AppServiceAccountCredentials credentials) {
        this.credentials = credentials;
    }

    public ServiceAccountDetailsAppAccountSub oktaApplicationId(String oktaApplicationId) {
        this.oktaApplicationId = oktaApplicationId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="aln1aqcs055ZRoizW0g8", required=true, value="The Okta app instance ID of the SaaS app")
    @JsonProperty(value="oktaApplicationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOktaApplicationId() {
        return this.oktaApplicationId;
    }

    @JsonProperty(value="oktaApplicationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOktaApplicationId(String oktaApplicationId) {
        this.oktaApplicationId = oktaApplicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountDetailsAppAccountSub serviceAccountDetailsAppAccountSub = (ServiceAccountDetailsAppAccountSub)o;
        return Objects.equals(this.appGlobalName, serviceAccountDetailsAppAccountSub.appGlobalName) && Objects.equals(this.appInstanceName, serviceAccountDetailsAppAccountSub.appInstanceName) && Objects.equals(this.credentials, serviceAccountDetailsAppAccountSub.credentials) && Objects.equals(this.oktaApplicationId, serviceAccountDetailsAppAccountSub.oktaApplicationId);
    }

    public int hashCode() {
        return Objects.hash(this.appGlobalName, this.appInstanceName, this.credentials, this.oktaApplicationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceAccountDetailsAppAccountSub {\n");
        sb.append("    appGlobalName: ").append(this.toIndentedString(this.appGlobalName)).append("\n");
        sb.append("    appInstanceName: ").append(this.toIndentedString(this.appInstanceName)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    oktaApplicationId: ").append(this.toIndentedString(this.oktaApplicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

