/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.ServiceAccountDetailsAppAccount;
import com.okta.sdk.resource.model.ServiceAccountDetailsOktaUserAccount;
import com.okta.sdk.resource.model.ServiceAccountStatus;
import com.okta.sdk.resource.model.ServiceAccountStatusDetail;
import com.okta.sdk.resource.model.ServiceAccountType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"accountType", "created", "description", "id", "lastUpdated", "name", "ownerGroupIds", "ownerUserIds", "status", "statusDetail"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="accountType", visible=true, defaultImpl=ServiceAccount.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ServiceAccountDetailsAppAccount.class, name="APP_ACCOUNT"), @JsonSubTypes.Type(value=ServiceAccountDetailsOktaUserAccount.class, name="OKTA_USER_ACCOUNT")})
public class ServiceAccount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    protected ServiceAccountType accountType;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_GROUP_IDS = "ownerGroupIds";
    private List<String> ownerGroupIds = null;
    public static final String JSON_PROPERTY_OWNER_USER_IDS = "ownerUserIds";
    private List<String> ownerUserIds = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ServiceAccountStatus status;
    public static final String JSON_PROPERTY_STATUS_DETAIL = "statusDetail";
    private ServiceAccountStatusDetail statusDetail;

    public ServiceAccount accountType(ServiceAccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceAccountType getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountType(ServiceAccountType accountType) {
        this.accountType = accountType;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the service account was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public ServiceAccount description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is for accessing salesforce Prod-5", value="The description of the service account")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(example="a747a818-a4c4-4446-8a87-704216495a08", value="The UUID of the service account")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the service account was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public ServiceAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="AWS Prod-5 account", required=true, value="The user-defined name for the service account")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ServiceAccount ownerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
        return this;
    }

    public ServiceAccount addownerGroupIdsItem(String ownerGroupIdsItem) {
        if (this.ownerGroupIds == null) {
            this.ownerGroupIds = new ArrayList<String>();
        }
        this.ownerGroupIds.add(ownerGroupIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00g57qp78yZT2XBA40g7\"]", value="A list of IDs of the Okta groups that own the service account")
    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerGroupIds() {
        return this.ownerGroupIds;
    }

    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
    }

    public ServiceAccount ownerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
        return this;
    }

    public ServiceAccount addownerUserIdsItem(String ownerUserIdsItem) {
        if (this.ownerUserIds == null) {
            this.ownerUserIds = new ArrayList<String>();
        }
        this.ownerUserIds.add(ownerUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00u11s48P9zGW8yqm0g5\"]", value="A list of IDs of the Okta users that own the service account")
    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerUserIds() {
        return this.ownerUserIds;
    }

    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public ServiceAccount status(ServiceAccountStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceAccountStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ServiceAccountStatus status) {
        this.status = status;
    }

    public ServiceAccount statusDetail(ServiceAccountStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="statusDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceAccountStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    @JsonProperty(value="statusDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusDetail(ServiceAccountStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccount serviceAccount = (ServiceAccount)o;
        return Objects.equals((Object)this.accountType, (Object)serviceAccount.accountType) && Objects.equals(this.created, serviceAccount.created) && Objects.equals(this.description, serviceAccount.description) && Objects.equals(this.id, serviceAccount.id) && Objects.equals(this.lastUpdated, serviceAccount.lastUpdated) && Objects.equals(this.name, serviceAccount.name) && Objects.equals(this.ownerGroupIds, serviceAccount.ownerGroupIds) && Objects.equals(this.ownerUserIds, serviceAccount.ownerUserIds) && Objects.equals((Object)this.status, (Object)serviceAccount.status) && Objects.equals((Object)this.statusDetail, (Object)serviceAccount.statusDetail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountType, this.created, this.description, this.id, this.lastUpdated, this.name, this.ownerGroupIds, this.ownerUserIds, this.status, this.statusDetail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceAccount {\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerGroupIds: ").append(this.toIndentedString(this.ownerGroupIds)).append("\n");
        sb.append("    ownerUserIds: ").append(this.toIndentedString(this.ownerUserIds)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusDetail: ").append(this.toIndentedString((Object)this.statusDetail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

