/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="JSON Web Token header for a Security Event Token sent by the SSF Transmitter")
@JsonPropertyOrder(value={"alg", "kid", "typ"})
public class SecurityEventTokenJwtHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_TYP = "typ";
    private String typ;

    public SecurityEventTokenJwtHeader alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RS256", required=true, value="Algorithm used to sign or encrypt the JWT")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    public SecurityEventTokenJwtHeader kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Key ID used to sign or encrypt the JWT")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public SecurityEventTokenJwtHeader typ(String typ) {
        this.typ = typ;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="secevent+jwt", required=true, value="The type of content being signed or encrypted")
    @JsonProperty(value="typ")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTyp() {
        return this.typ;
    }

    @JsonProperty(value="typ")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTyp(String typ) {
        this.typ = typ;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenJwtHeader securityEventTokenJwtHeader = (SecurityEventTokenJwtHeader)o;
        return Objects.equals(this.alg, securityEventTokenJwtHeader.alg) && Objects.equals(this.kid, securityEventTokenJwtHeader.kid) && Objects.equals(this.typ, securityEventTokenJwtHeader.typ);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.kid, this.typ);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenJwtHeader {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    typ: ").append(this.toIndentedString(this.typ)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

