/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Federation Trust Credentials for verifying assertions from the IdP")
@JsonPropertyOrder(value={"additionalKids", "audience", "issuer", "kid"})
public class SamlTrustCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ADDITIONAL_KIDS = "additionalKids";
    private List<String> additionalKids = null;
    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    private String audience;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public SamlTrustCredentials additionalKids(List<String> additionalKids) {
        this.additionalKids = additionalKids;
        return this;
    }

    public SamlTrustCredentials addadditionalKidsItem(String additionalKidsItem) {
        if (this.additionalKids == null) {
            this.additionalKids = new ArrayList<String>();
        }
        this.additionalKids.add(additionalKidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional IdP key credential reference to the Okta X.509 signature certificate")
    @JsonProperty(value="additionalKids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAdditionalKids() {
        return this.additionalKids;
    }

    @JsonProperty(value="additionalKids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalKids(List<String> additionalKids) {
        this.additionalKids = additionalKids;
    }

    public SamlTrustCredentials audience(String audience) {
        this.audience = audience;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.okta.com/saml2/service-provider/spgv32vOnpdyeGSaiUpL", value="URI that identifies the target Okta IdP instance (SP) for an `<Assertion>`")
    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudience() {
        return this.audience;
    }

    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public SamlTrustCredentials issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="urn:example:idp", value="URI that identifies the issuer (IdP) of a `<SAMLResponse>` message `<Assertion>` element")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SamlTrustCredentials kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-key-id", value="IdP key credential reference to the Okta X.509 signature certificate")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlTrustCredentials samlTrustCredentials = (SamlTrustCredentials)o;
        return Objects.equals(this.additionalKids, samlTrustCredentials.additionalKids) && Objects.equals(this.audience, samlTrustCredentials.audience) && Objects.equals(this.issuer, samlTrustCredentials.issuer) && Objects.equals(this.kid, samlTrustCredentials.kid);
    }

    public int hashCode() {
        return Objects.hash(this.additionalKids, this.audience, this.issuer, this.kid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlTrustCredentials {\n");
        sb.append("    additionalKids: ").append(this.toIndentedString(this.additionalKids)).append("\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

