/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Key used for signing requests to the IdP")
@JsonPropertyOrder(value={"kid"})
public class SamlSigningCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public SamlSigningCredentials kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-key-id", value="IdP key credential reference to the Okta X.509 signature certificate")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlSigningCredentials samlSigningCredentials = (SamlSigningCredentials)o;
        return Objects.equals(this.kid, samlSigningCredentials.kid);
    }

    public int hashCode() {
        return Objects.hash(this.kid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSigningCredentials {\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

