/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Generic `EXPRESSION` attribute statements")
@JsonPropertyOrder(value={"name", "namespace", "type", "values"})
public class SamlAttributeStatementExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private NamespaceEnum namespace;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public SamlAttributeStatementExpression name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="attributeOne", value="The name of the attribute in your app. The attribute name must be unique across all user and group attribute statements.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SamlAttributeStatementExpression namespace(NamespaceEnum namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="urn:oasis:names:tc:SAML:2.0:attrname-format:basic", value="The name format of the attribute. Supported values:")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NamespaceEnum getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamespace(NamespaceEnum namespace) {
        this.namespace = namespace;
    }

    public SamlAttributeStatementExpression type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="EXPRESSION", value="The type of attribute statements object")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SamlAttributeStatementExpression values(List<String> values) {
        this.values = values;
        return this;
    }

    public SamlAttributeStatementExpression addvaluesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The attribute values (supports [Okta Expression Language](https://developer.okta.com/docs/reference/okta-expression-language/))")
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlAttributeStatementExpression samlAttributeStatementExpression = (SamlAttributeStatementExpression)o;
        return Objects.equals(this.name, samlAttributeStatementExpression.name) && Objects.equals((Object)this.namespace, (Object)samlAttributeStatementExpression.namespace) && Objects.equals((Object)this.type, (Object)samlAttributeStatementExpression.type) && Objects.equals(this.values, samlAttributeStatementExpression.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.namespace, this.type, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlAttributeStatementExpression {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString((Object)this.namespace)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NamespaceEnum {
        URN_OASIS_NAMES_TC_SAML_2_0_ATTRNAME_FORMAT_BASIC(String.valueOf("urn:oasis:names:tc:SAML:2.0:attrname-format:basic")),
        URN_OASIS_NAMES_TC_SAML_2_0_ATTRNAME_FORMAT_URI(String.valueOf("urn:oasis:names:tc:SAML:2.0:attrname-format:uri")),
        URN_OASIS_NAMES_TC_SAML_2_0_ATTRNAME_FORMAT_UNSPECIFIED(String.valueOf("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private NamespaceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NamespaceEnum fromValue(String value) {
            for (NamespaceEnum b : NamespaceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum TypeEnum {
        EXPRESSION(String.valueOf("EXPRESSION")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

