/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Determines if the app supports encrypted assertions")
@JsonPropertyOrder(value={"enabled", "encryptionAlgorithm", "keyTransportAlgorithm", "x5c"})
public class SamlAssertionEncryption
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_ENCRYPTION_ALGORITHM = "encryptionAlgorithm";
    private EncryptionAlgorithmEnum encryptionAlgorithm;
    public static final String JSON_PROPERTY_KEY_TRANSPORT_ALGORITHM = "keyTransportAlgorithm";
    private KeyTransportAlgorithmEnum keyTransportAlgorithm;
    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;

    public SamlAssertionEncryption enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether Okta encrypts the assertions that it sends to the Service Provider")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SamlAssertionEncryption encryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The encryption algorithm used to encrypt the SAML assertion")
    @JsonProperty(value="encryptionAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EncryptionAlgorithmEnum getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @JsonProperty(value="encryptionAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public SamlAssertionEncryption keyTransportAlgorithm(KeyTransportAlgorithmEnum keyTransportAlgorithm) {
        this.keyTransportAlgorithm = keyTransportAlgorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key transport algorithm used to encrypt the SAML assertion")
    @JsonProperty(value="keyTransportAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyTransportAlgorithmEnum getKeyTransportAlgorithm() {
        return this.keyTransportAlgorithm;
    }

    @JsonProperty(value="keyTransportAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyTransportAlgorithm(KeyTransportAlgorithmEnum keyTransportAlgorithm) {
        this.keyTransportAlgorithm = keyTransportAlgorithm;
    }

    public SamlAssertionEncryption x5c(List<String> x5c) {
        this.x5c = x5c;
        return this;
    }

    public SamlAssertionEncryption addx5cItem(String x5cItem) {
        if (this.x5c == null) {
            this.x5c = new ArrayList<String>();
        }
        this.x5c.add(x5cItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list that contains exactly one x509 encoded certificate which Okta uses to encrypt the SAML assertion with")
    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getX5c() {
        return this.x5c;
    }

    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlAssertionEncryption samlAssertionEncryption = (SamlAssertionEncryption)o;
        return Objects.equals(this.enabled, samlAssertionEncryption.enabled) && Objects.equals((Object)this.encryptionAlgorithm, (Object)samlAssertionEncryption.encryptionAlgorithm) && Objects.equals((Object)this.keyTransportAlgorithm, (Object)samlAssertionEncryption.keyTransportAlgorithm) && Objects.equals(this.x5c, samlAssertionEncryption.x5c);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.encryptionAlgorithm, this.keyTransportAlgorithm, this.x5c});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlAssertionEncryption {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    encryptionAlgorithm: ").append(this.toIndentedString((Object)this.encryptionAlgorithm)).append("\n");
        sb.append("    keyTransportAlgorithm: ").append(this.toIndentedString((Object)this.keyTransportAlgorithm)).append("\n");
        sb.append("    x5c: ").append(this.toIndentedString(this.x5c)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EncryptionAlgorithmEnum {
        AES128_CBC(String.valueOf("AES128_CBC")),
        AES256_CBC(String.valueOf("AES256_CBC")),
        AES256_CBC2(String.valueOf("AES256_CBC")),
        AES256_GCM(String.valueOf("AES256_GCM")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private EncryptionAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionAlgorithmEnum fromValue(String value) {
            for (EncryptionAlgorithmEnum b : EncryptionAlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum KeyTransportAlgorithmEnum {
        RSA_OAEP(String.valueOf("RSA_OAEP")),
        RSA_15(String.valueOf("RSA_15")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private KeyTransportAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeyTransportAlgorithmEnum fromValue(String value) {
            for (KeyTransportAlgorithmEnum b : KeyTransportAlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

