/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SamlAcsInner;
import com.okta.sdk.resource.model.SamlClaimsInner;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="SAML configuration details")
@JsonPropertyOrder(value={"acs", "claims", "doc", "entityId", "groups"})
public class Saml
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACS = "acs";
    private List<SamlAcsInner> acs = new ArrayList<SamlAcsInner>();
    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private List<SamlClaimsInner> claims = null;
    public static final String JSON_PROPERTY_DOC = "doc";
    private URI doc;
    public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
    private String entityId;
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<String> groups = null;

    public Saml acs(List<SamlAcsInner> acs) {
        this.acs = acs;
        return this;
    }

    public Saml addacsItem(SamlAcsInner acsItem) {
        if (this.acs == null) {
            this.acs = new ArrayList<SamlAcsInner>();
        }
        this.acs.add(acsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of Assertion Consumer Service (ACS) URLs. The default ACS URL is required and is indicated by a null `index` value. You can use the org-level variables you defined in the `config` array in the URL. For example: `https://${org.subdomain}.example.com/saml/login`")
    @JsonProperty(value="acs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SamlAcsInner> getAcs() {
        return this.acs;
    }

    @JsonProperty(value="acs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcs(List<SamlAcsInner> acs) {
        this.acs = acs;
    }

    public Saml claims(List<SamlClaimsInner> claims) {
        this.claims = claims;
        return this;
    }

    public Saml addclaimsItem(SamlClaimsInner claimsItem) {
        if (this.claims == null) {
            this.claims = new ArrayList<SamlClaimsInner>();
        }
        this.claims.add(claimsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attribute statements to appear in the Okta SAML assertion")
    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SamlClaimsInner> getClaims() {
        return this.claims;
    }

    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(List<SamlClaimsInner> claims) {
        this.claims = claims;
    }

    public Saml doc(URI doc) {
        this.doc = doc;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.com/strawberry/help/samlSetup", required=true, value="The URL to your customer-facing instructions for configuring your SAML integration. See [Customer configuration document guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).")
    @JsonProperty(value="doc")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getDoc() {
        return this.doc;
    }

    @JsonProperty(value="doc")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDoc(URI doc) {
        this.doc = doc;
    }

    public Saml entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://${org.subdomain}.example.com", required=true, value="Globally unique name for your SAML entity. For instance, your Identity Provider (IdP) or Service Provider (SP) URL.")
    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Saml groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public Saml addgroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines the group attribute names for the SAML assertion statement. Okta inserts the list of Okta user groups into the attribute names in the statement.")
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Saml saml = (Saml)o;
        return Objects.equals(this.acs, saml.acs) && Objects.equals(this.claims, saml.claims) && Objects.equals(this.doc, saml.doc) && Objects.equals(this.entityId, saml.entityId) && Objects.equals(this.groups, saml.groups);
    }

    public int hashCode() {
        return Objects.hash(this.acs, this.claims, this.doc, this.entityId, this.groups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Saml {\n");
        sb.append("    acs: ").append(this.toIndentedString(this.acs)).append("\n");
        sb.append("    claims: ").append(this.toIndentedString(this.claims)).append("\n");
        sb.append("    doc: ").append(this.toIndentedString(this.doc)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

