/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.GovernanceSourceType;
import com.okta.sdk.resource.model.RoleGovernanceSourceLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="User role governance source")
@JsonPropertyOrder(value={"bundleId", "expirationDate", "grantId", "type", "_links"})
public class RoleGovernanceSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BUNDLE_ID = "bundleId";
    private String bundleId;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    private OffsetDateTime expirationDate;
    public static final String JSON_PROPERTY_GRANT_ID = "grantId";
    private String grantId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GovernanceSourceType type;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private RoleGovernanceSourceLinks links;

    @Nullable
    @ApiModelProperty(value="`id` of the entitlement bundle")
    @JsonProperty(value="bundleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBundleId() {
        return this.bundleId;
    }

    @Nullable
    @ApiModelProperty(value="The expiration date of the entitlement bundle")
    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`id` of the grant")
    @JsonProperty(value="grantId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGrantId() {
        return this.grantId;
    }

    public RoleGovernanceSource type(GovernanceSourceType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GovernanceSourceType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(GovernanceSourceType type) {
        this.type = type;
    }

    public RoleGovernanceSource links(RoleGovernanceSourceLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoleGovernanceSourceLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(RoleGovernanceSourceLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleGovernanceSource roleGovernanceSource = (RoleGovernanceSource)o;
        return Objects.equals(this.bundleId, roleGovernanceSource.bundleId) && Objects.equals(this.expirationDate, roleGovernanceSource.expirationDate) && Objects.equals(this.grantId, roleGovernanceSource.grantId) && Objects.equals((Object)this.type, (Object)roleGovernanceSource.type) && Objects.equals(this.links, roleGovernanceSource.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bundleId, this.expirationDate, this.grantId, this.type, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleGovernanceSource {\n");
        sb.append("    bundleId: ").append(this.toIndentedString(this.bundleId)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    grantId: ").append(this.toIndentedString(this.grantId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

