/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.JsonWebKeyStatus;
import com.okta.sdk.resource.model.JsonWebKeyType;
import com.okta.sdk.resource.model.JsonWebKeyUse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A [JSON Web Key (JWK)](https://tools.ietf.org/html/rfc7517) is a JSON representation of a cryptographic key. Okta can use the active key to encrypt the access token minted by the authorization server. Okta supports only RSA keys with 'use: enc'.")
@JsonPropertyOrder(value={"e", "kid", "kty", "n", "status", "use"})
public class ResourceServerJsonWebKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    private JsonWebKeyType kty;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_STATUS = "status";
    private JsonWebKeyStatus status;
    public static final String JSON_PROPERTY_USE = "use";
    private JsonWebKeyUse use;

    public ResourceServerJsonWebKey e(String e) {
        this.e = e;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key exponent of a RSA key")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    public ResourceServerJsonWebKey kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the key")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public ResourceServerJsonWebKey kty(JsonWebKeyType kty) {
        this.kty = kty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonWebKeyType getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKty(JsonWebKeyType kty) {
        this.kty = kty;
    }

    public ResourceServerJsonWebKey n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The modulus of the RSA key")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public ResourceServerJsonWebKey status(JsonWebKeyStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonWebKeyStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(JsonWebKeyStatus status) {
        this.status = status;
    }

    public ResourceServerJsonWebKey use(JsonWebKeyUse use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonWebKeyUse getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(JsonWebKeyUse use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceServerJsonWebKey resourceServerJsonWebKey = (ResourceServerJsonWebKey)o;
        return Objects.equals(this.e, resourceServerJsonWebKey.e) && Objects.equals(this.kid, resourceServerJsonWebKey.kid) && Objects.equals((Object)this.kty, (Object)resourceServerJsonWebKey.kty) && Objects.equals(this.n, resourceServerJsonWebKey.n) && Objects.equals((Object)this.status, (Object)resourceServerJsonWebKey.status) && Objects.equals((Object)this.use, (Object)resourceServerJsonWebKey.use);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.e, this.kid, this.kty, this.n, this.status, this.use});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceServerJsonWebKey {\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

