/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.RegistrationResponseErrorErrorCausesInner;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="For the registration inline hook, the `error` object provides a way of displaying an error message to the end user who is trying to register or update their profile.  * If you're using the Okta Sign-In Widget for Profile Enrollment, only the `errorSummary` messages of the `errorCauses` objects that your external service returns appear as inline errors, given the following:   * You don't customize the error handling behavior of the widget.   * The `location` of `errorSummary` in the `errorCauses` object specifies the request object's user profile attribute. * If you don't return a value for the `errorCauses` object, and deny the user's registration attempt through the `commands` object in your response to Okta, one of the following generic messages appears to the end user:   * \"Registration cannot be completed at this time.\" (SSR)   * \"We found some errors. Please review the form and make corrections.\" (Progressive Enrollment) * If you don't return an `error` object at all and the registration is denied, the following generic message appears to the end user:   * \"Registration denied.\" (SSR)   * \"Profile update denied.\" (Progressive Enrollment)  >**Note:** If you include an error object in your response, no commands are executed and the registration fails. This holds true even if the top-level `errorSummary` and the `errorCauses` objects are omitted.")
@JsonPropertyOrder(value={"errorSummary", "errorCauses"})
@JsonTypeName(value="RegistrationResponse_Error")
public class RegistrationResponseError
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;
    public static final String JSON_PROPERTY_ERROR_CAUSES = "errorCauses";
    private List<RegistrationResponseErrorErrorCausesInner> errorCauses = null;

    public RegistrationResponseError errorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable summary of one or more errors")
    @JsonProperty(value="errorSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorSummary() {
        return this.errorSummary;
    }

    @JsonProperty(value="errorSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    public RegistrationResponseError errorCauses(List<RegistrationResponseErrorErrorCausesInner> errorCauses) {
        this.errorCauses = errorCauses;
        return this;
    }

    public RegistrationResponseError adderrorCausesItem(RegistrationResponseErrorErrorCausesInner errorCausesItem) {
        if (this.errorCauses == null) {
            this.errorCauses = new ArrayList<RegistrationResponseErrorErrorCausesInner>();
        }
        this.errorCauses.add(errorCausesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="errorCauses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RegistrationResponseErrorErrorCausesInner> getErrorCauses() {
        return this.errorCauses;
    }

    @JsonProperty(value="errorCauses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCauses(List<RegistrationResponseErrorErrorCausesInner> errorCauses) {
        this.errorCauses = errorCauses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationResponseError registrationResponseError = (RegistrationResponseError)o;
        return Objects.equals(this.errorSummary, registrationResponseError.errorSummary) && Objects.equals(this.errorCauses, registrationResponseError.errorCauses);
    }

    public int hashCode() {
        return Objects.hash(this.errorSummary, this.errorCauses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationResponseError {\n");
        sb.append("    errorSummary: ").append(this.toIndentedString(this.errorSummary)).append("\n");
        sb.append("    errorCauses: ").append(this.toIndentedString(this.errorCauses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

