/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Scim;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Supported provisioning configurations for your integration")
@JsonPropertyOrder(value={"features", "scim"})
public class ProvisioningDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<FeaturesEnum> features = new ArrayList<FeaturesEnum>();
    public static final String JSON_PROPERTY_SCIM = "scim";
    private Scim scim;

    public ProvisioningDetails features(List<FeaturesEnum> features) {
        this.features = features;
        return this;
    }

    public ProvisioningDetails addfeaturesItem(FeaturesEnum featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<FeaturesEnum>();
        }
        this.features.add(featuresItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of provisioning features supported in this integration")
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FeaturesEnum> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeatures(List<FeaturesEnum> features) {
        this.features = features;
    }

    public ProvisioningDetails scim(Scim scim) {
        this.scim = scim;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="scim")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Scim getScim() {
        return this.scim;
    }

    @JsonProperty(value="scim")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScim(Scim scim) {
        this.scim = scim;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProvisioningDetails provisioningDetails = (ProvisioningDetails)o;
        return Objects.equals(this.features, provisioningDetails.features) && Objects.equals(this.scim, provisioningDetails.scim);
    }

    public int hashCode() {
        return Objects.hash(this.features, this.scim);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningDetails {\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    scim: ").append(this.toIndentedString(this.scim)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeaturesEnum {
        CREATE_USER(String.valueOf("CREATE_USER")),
        READ_USER(String.valueOf("READ_USER")),
        UPDATE_USER(String.valueOf("UPDATE_USER")),
        DEACTIVATE_USER(String.valueOf("DEACTIVATE_USER")),
        CREATE_GROUP(String.valueOf("CREATE_GROUP")),
        READ_GROUP(String.valueOf("READ_GROUP")),
        UPDATE_GROUP(String.valueOf("UPDATE_GROUP")),
        DEACTIVATE_GROUP(String.valueOf("DEACTIVATE_GROUP")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FeaturesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeaturesEnum fromValue(String value) {
            for (FeaturesEnum b : FeaturesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

