/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Credentials for the privileged resource")
@JsonPropertyOrder(value={"password", "userName"})
public class PrivilegedResourceCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public PrivilegedResourceCredentials password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="xf1bs9am2", value="The password associated with the privileged resource")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public PrivilegedResourceCredentials userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testuser@example.com", required=true, value="The username associated with the privileged resource")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceCredentials privilegedResourceCredentials = (PrivilegedResourceCredentials)o;
        return Objects.equals(this.password, privilegedResourceCredentials.password) && Objects.equals(this.userName, privilegedResourceCredentials.userName);
    }

    public int hashCode() {
        return Objects.hash(this.password, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceCredentials {\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

