/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="[Okta Expression Language (EL) expression](https://developer.okta.com/docs/reference/okta-expression-language/) to generate or transform a unique username for the IdP user. * IdP user profile attributes can be referenced with the `idpuser` prefix such as `idpuser.subjectNameId`. * You must define an IdP user profile attribute before it can be referenced in an Okta EL expression. To define an IdP user attribute policy, you may need to create a new IdP instance without a base profile property. Then edit the IdP user profile to update the IdP instance with an expression that references the IdP user profile attribute that you just created.")
@JsonPropertyOrder(value={"template"})
public class PolicyUserNameTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template;

    public PolicyUserNameTemplate template(String template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="idpuser.subjectNameId", value="")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyUserNameTemplate policyUserNameTemplate = (PolicyUserNameTemplate)o;
        return Objects.equals(this.template, policyUserNameTemplate.template);
    }

    public int hashCode() {
        return Objects.hash(this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyUserNameTemplate {\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

