/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.PolicyLinks;
import com.okta.sdk.resource.model.PolicyType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "description", "id", "lastUpdated", "name", "priority", "status", "system", "type", "_embedded", "_links"})
public class PolicyCommon
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id = "Assigned";
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private Integer priority;
    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;
    public static final String JSON_PROPERTY_SYSTEM = "system";
    private Boolean system = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private PolicyType type;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private PolicyLinks links;

    @Nullable
    @ApiModelProperty(value="Timestamp when the policy was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public PolicyCommon description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the Policy")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the Policy")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the policy was last modified")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public PolicyCommon name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name of the policy")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PolicyCommon priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the order in which this policy is evaluated in relation to the other policies")
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public PolicyCommon status(LifecycleStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the policy is active. Use the `activate` query parameter to set the status of a policy.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifecycleStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public PolicyCommon system(Boolean system) {
        this.system = system;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether Okta created the Policy")
    @JsonProperty(value="system")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSystem() {
        return this.system;
    }

    @JsonProperty(value="system")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSystem(Boolean system) {
        this.system = system;
    }

    public PolicyCommon type(PolicyType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PolicyType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(PolicyType type) {
        this.type = type;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    public PolicyCommon links(PolicyLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicyLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(PolicyLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyCommon policyCommon = (PolicyCommon)o;
        return Objects.equals(this.created, policyCommon.created) && Objects.equals(this.description, policyCommon.description) && Objects.equals(this.id, policyCommon.id) && Objects.equals(this.lastUpdated, policyCommon.lastUpdated) && Objects.equals(this.name, policyCommon.name) && Objects.equals(this.priority, policyCommon.priority) && Objects.equals((Object)this.status, (Object)policyCommon.status) && Objects.equals(this.system, policyCommon.system) && Objects.equals((Object)this.type, (Object)policyCommon.type) && Objects.equals(this.embedded, policyCommon.embedded) && Objects.equals(this.links, policyCommon.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.description, this.id, this.lastUpdated, this.name, this.priority, this.status, this.system, this.type, this.embedded, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyCommon {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

