/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Breached Protection settings")
@JsonPropertyOrder(value={"delegatedWorkflowId", "expireAfterDays", "logoutEnabled"})
public class PasswordPolicyPasswordSettingsBreachedProtection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DELEGATED_WORKFLOW_ID = "delegatedWorkflowId";
    private JsonNullable<String> delegatedWorkflowId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPIRE_AFTER_DAYS = "expireAfterDays";
    private JsonNullable<Integer> expireAfterDays = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LOGOUT_ENABLED = "logoutEnabled";
    private JsonNullable<Boolean> logoutEnabled = JsonNullable.of((Object)false);

    public PasswordPolicyPasswordSettingsBreachedProtection delegatedWorkflowId(String delegatedWorkflowId) {
        this.delegatedWorkflowId = JsonNullable.of((Object)delegatedWorkflowId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `id` of the workflow that runs when a breached password is found during a sign-in attempt.")
    @JsonIgnore
    public String getDelegatedWorkflowId() {
        return (String)this.delegatedWorkflowId.orElse(null);
    }

    @JsonProperty(value="delegatedWorkflowId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDelegatedWorkflowId_JsonNullable() {
        return this.delegatedWorkflowId;
    }

    @JsonProperty(value="delegatedWorkflowId")
    public void setDelegatedWorkflowId_JsonNullable(JsonNullable<String> delegatedWorkflowId) {
        this.delegatedWorkflowId = delegatedWorkflowId;
    }

    public void setDelegatedWorkflowId(String delegatedWorkflowId) {
        this.delegatedWorkflowId = JsonNullable.of((Object)delegatedWorkflowId);
    }

    public PasswordPolicyPasswordSettingsBreachedProtection expireAfterDays(Integer expireAfterDays) {
        this.expireAfterDays = JsonNullable.of((Object)expireAfterDays);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the number of days after a breached password is found during a sign-in attempt that the user's password should expire. Valid values: 0 through 10. If set to 0, it happens immediately.")
    @JsonIgnore
    public Integer getExpireAfterDays() {
        return (Integer)this.expireAfterDays.orElse(null);
    }

    @JsonProperty(value="expireAfterDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getExpireAfterDays_JsonNullable() {
        return this.expireAfterDays;
    }

    @JsonProperty(value="expireAfterDays")
    public void setExpireAfterDays_JsonNullable(JsonNullable<Integer> expireAfterDays) {
        this.expireAfterDays = expireAfterDays;
    }

    public void setExpireAfterDays(Integer expireAfterDays) {
        this.expireAfterDays = JsonNullable.of((Object)expireAfterDays);
    }

    public PasswordPolicyPasswordSettingsBreachedProtection logoutEnabled(Boolean logoutEnabled) {
        this.logoutEnabled = JsonNullable.of((Object)logoutEnabled);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(Optional, default is false) If true, you must also specify a value for `expireAfterDays`. When enabled, the user's session(s) are terminated immediately the first time the user's credentials are detected as part of a breach.")
    @JsonIgnore
    public Boolean getLogoutEnabled() {
        return (Boolean)this.logoutEnabled.orElse(null);
    }

    @JsonProperty(value="logoutEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getLogoutEnabled_JsonNullable() {
        return this.logoutEnabled;
    }

    @JsonProperty(value="logoutEnabled")
    public void setLogoutEnabled_JsonNullable(JsonNullable<Boolean> logoutEnabled) {
        this.logoutEnabled = logoutEnabled;
    }

    public void setLogoutEnabled(Boolean logoutEnabled) {
        this.logoutEnabled = JsonNullable.of((Object)logoutEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyPasswordSettingsBreachedProtection passwordPolicyPasswordSettingsBreachedProtection = (PasswordPolicyPasswordSettingsBreachedProtection)o;
        return PasswordPolicyPasswordSettingsBreachedProtection.equalsNullable(this.delegatedWorkflowId, passwordPolicyPasswordSettingsBreachedProtection.delegatedWorkflowId) && PasswordPolicyPasswordSettingsBreachedProtection.equalsNullable(this.expireAfterDays, passwordPolicyPasswordSettingsBreachedProtection.expireAfterDays) && PasswordPolicyPasswordSettingsBreachedProtection.equalsNullable(this.logoutEnabled, passwordPolicyPasswordSettingsBreachedProtection.logoutEnabled);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(PasswordPolicyPasswordSettingsBreachedProtection.hashCodeNullable(this.delegatedWorkflowId), PasswordPolicyPasswordSettingsBreachedProtection.hashCodeNullable(this.expireAfterDays), PasswordPolicyPasswordSettingsBreachedProtection.hashCodeNullable(this.logoutEnabled));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyPasswordSettingsBreachedProtection {\n");
        sb.append("    delegatedWorkflowId: ").append(this.toIndentedString(this.delegatedWorkflowId)).append("\n");
        sb.append("    expireAfterDays: ").append(this.toIndentedString(this.expireAfterDays)).append("\n");
        sb.append("    logoutEnabled: ").append(this.toIndentedString(this.logoutEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

