/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Attributes used for processing Active Directory group membership update")
@JsonPropertyOrder(value={"action", "attribute", "values"})
public class Parameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACTION = "action";
    private ActionEnum action;
    public static final String JSON_PROPERTY_ATTRIBUTE = "attribute";
    private String attribute;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public Parameters action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The update action to take")
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public Parameters attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="member", value="The attribute that tracks group memberships in Active Directory. For Active Directory, use `member`.")
    @JsonProperty(value="attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttribute() {
        return this.attribute;
    }

    @JsonProperty(value="attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Parameters values(List<String> values) {
        this.values = values;
        return this;
    }

    public Parameters addvaluesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of user IDs whose group memberships to update")
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameters parameters = (Parameters)o;
        return Objects.equals((Object)this.action, (Object)parameters.action) && Objects.equals(this.attribute, parameters.attribute) && Objects.equals(this.values, parameters.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.attribute, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Parameters {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        ADD(String.valueOf("ADD")),
        REMOVE(String.valueOf("REMOVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

