/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="OAuth 2.0 and OpenID Connect Client object > **Note:** You must complete client registration with the IdP Authorization Server for your Okta IdP instance to obtain client credentials.")
@JsonPropertyOrder(value={"client_id", "client_secret", "pkce_required", "token_endpoint_auth_method"})
public class OAuthCredentialsClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_PKCE_REQUIRED = "pkce_required";
    private Boolean pkceRequired;
    public static final String JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD = "token_endpoint_auth_method";
    private TokenEndpointAuthMethodEnum tokenEndpointAuthMethod;

    public OAuthCredentialsClient clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-client-id", value="The [Unique identifier](https://tools.ietf.org/html/rfc6749#section-2.2) issued by the AS for the Okta IdP instance")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthCredentialsClient clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-client-secret", value="The [Client secret](https://tools.ietf.org/html/rfc6749#section-2.3.1) issued by the AS for the Okta IdP instance")
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthCredentialsClient pkceRequired(Boolean pkceRequired) {
        this.pkceRequired = pkceRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require Proof Key for Code Exchange (PKCE) for additional verification")
    @JsonProperty(value="pkce_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPkceRequired() {
        return this.pkceRequired;
    }

    @JsonProperty(value="pkce_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPkceRequired(Boolean pkceRequired) {
        this.pkceRequired = pkceRequired;
    }

    public OAuthCredentialsClient tokenEndpointAuthMethod(TokenEndpointAuthMethodEnum tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Client authentication methods supported by the token endpoint")
    @JsonProperty(value="token_endpoint_auth_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenEndpointAuthMethodEnum getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    @JsonProperty(value="token_endpoint_auth_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEndpointAuthMethod(TokenEndpointAuthMethodEnum tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthCredentialsClient oauthCredentialsClient = (OAuthCredentialsClient)o;
        return Objects.equals(this.clientId, oauthCredentialsClient.clientId) && Objects.equals(this.clientSecret, oauthCredentialsClient.clientSecret) && Objects.equals(this.pkceRequired, oauthCredentialsClient.pkceRequired) && Objects.equals((Object)this.tokenEndpointAuthMethod, (Object)oauthCredentialsClient.tokenEndpointAuthMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.clientSecret, this.pkceRequired, this.tokenEndpointAuthMethod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthCredentialsClient {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    pkceRequired: ").append(this.toIndentedString(this.pkceRequired)).append("\n");
        sb.append("    tokenEndpointAuthMethod: ").append(this.toIndentedString((Object)this.tokenEndpointAuthMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenEndpointAuthMethodEnum {
        PRIVATE_KEY_JWT(String.valueOf("private_key_jwt")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TokenEndpointAuthMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenEndpointAuthMethodEnum fromValue(String value) {
            for (TokenEndpointAuthMethodEnum b : TokenEndpointAuthMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

