/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AppleClientSigning;
import com.okta.sdk.resource.model.OAuthCredentialsClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Client authentication credentials for an [OAuth 2.0 Authorization Server](https://tools.ietf.org/html/rfc6749#section-2.3)")
@JsonPropertyOrder(value={"client", "signing"})
public class OAuthCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT = "client";
    private OAuthCredentialsClient client;
    public static final String JSON_PROPERTY_SIGNING = "signing";
    private AppleClientSigning signing;

    public OAuthCredentials client(OAuthCredentialsClient client) {
        this.client = client;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="client")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthCredentialsClient getClient() {
        return this.client;
    }

    @JsonProperty(value="client")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClient(OAuthCredentialsClient client) {
        this.client = client;
    }

    public OAuthCredentials signing(AppleClientSigning signing) {
        this.signing = signing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppleClientSigning getSigning() {
        return this.signing;
    }

    @JsonProperty(value="signing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigning(AppleClientSigning signing) {
        this.signing = signing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthCredentials oauthCredentials = (OAuthCredentials)o;
        return Objects.equals(this.client, oauthCredentials.client) && Objects.equals(this.signing, oauthCredentials.signing);
    }

    public int hashCode() {
        return Objects.hash(this.client, this.signing);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthCredentials {\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    signing: ").append(this.toIndentedString(this.signing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

