/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.CustomAuthorizationServerLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Secret for the managed connection")
@JsonPropertyOrder(value={"description", "name", "orn", "path", "_links"})
public class ManagedConnectionVaultedSecret
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private CustomAuthorizationServerLinks links;

    public ManagedConnectionVaultedSecret description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional description of the secret")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ManagedConnectionVaultedSecret name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Display name of the secret")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ManagedConnectionVaultedSecret orn(String orn) {
        this.orn = orn;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The [ORN](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the vaulted secret")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrn() {
        return this.orn;
    }

    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public ManagedConnectionVaultedSecret path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secret path in Okta Privileged Access (OPA)")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public ManagedConnectionVaultedSecret links(CustomAuthorizationServerLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomAuthorizationServerLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinks(CustomAuthorizationServerLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedConnectionVaultedSecret managedConnectionVaultedSecret = (ManagedConnectionVaultedSecret)o;
        return Objects.equals(this.description, managedConnectionVaultedSecret.description) && Objects.equals(this.name, managedConnectionVaultedSecret.name) && Objects.equals(this.orn, managedConnectionVaultedSecret.orn) && Objects.equals(this.path, managedConnectionVaultedSecret.path) && Objects.equals(this.links, managedConnectionVaultedSecret.links);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.orn, this.path, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagedConnectionVaultedSecret {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

