/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.CustomAuthorizationServerLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Service account for the managed connection")
@JsonPropertyOrder(value={"name", "orn", "_links"})
public class ManagedConnectionServiceAccount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private CustomAuthorizationServerLinks links;

    public ManagedConnectionServiceAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Display name of the service account")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ManagedConnectionServiceAccount orn(String orn) {
        this.orn = orn;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The [ORN](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the service account")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrn() {
        return this.orn;
    }

    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public ManagedConnectionServiceAccount links(CustomAuthorizationServerLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomAuthorizationServerLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinks(CustomAuthorizationServerLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedConnectionServiceAccount managedConnectionServiceAccount = (ManagedConnectionServiceAccount)o;
        return Objects.equals(this.name, managedConnectionServiceAccount.name) && Objects.equals(this.orn, managedConnectionServiceAccount.orn) && Objects.equals(this.links, managedConnectionServiceAccount.links);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.orn, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagedConnectionServiceAccount {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

