/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.UserSchemaAttributeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"$schema", "errorMessage", "id", "oneOf", "pattern", "properties", "required", "title", "type", "_links"})
public class LogStreamSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_$_SCHEMA = "$schema";
    private String $schema;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private Object errorMessage;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ONE_OF = "oneOf";
    private JsonNullable<List<UserSchemaAttributeEnum>> oneOf = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PATTERN = "pattern";
    private String pattern;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Object properties;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private List<String> required = null;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(value="JSON schema version identifier")
    @JsonProperty(value="$schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String get$Schema() {
        return this.$schema;
    }

    public LogStreamSchema errorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A collection of error messages for individual properties in the schema. Okta implements a subset of [ajv-errors](https://github.com/ajv-validator/ajv-errors).")
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Nullable
    @ApiModelProperty(value="URI of log stream schema")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public LogStreamSchema oneOf(List<UserSchemaAttributeEnum> oneOf) {
        this.oneOf = JsonNullable.of(oneOf);
        return this;
    }

    public LogStreamSchema addoneOfItem(UserSchemaAttributeEnum oneOfItem) {
        if (this.oneOf == null || !this.oneOf.isPresent()) {
            this.oneOf = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.oneOf.get()).add(oneOfItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Non-empty array of valid JSON schemas.  Okta only supports `oneOf` for specifying display names for an `enum`. Each schema has the following format:  ``` {   \"const\": \"enumValue\",   \"title\": \"display name\" } ```")
    @JsonIgnore
    public List<UserSchemaAttributeEnum> getOneOf() {
        return (List)this.oneOf.orElse(null);
    }

    @JsonProperty(value="oneOf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<UserSchemaAttributeEnum>> getOneOf_JsonNullable() {
        return this.oneOf;
    }

    @JsonProperty(value="oneOf")
    public void setOneOf_JsonNullable(JsonNullable<List<UserSchemaAttributeEnum>> oneOf) {
        this.oneOf = oneOf;
    }

    public void setOneOf(List<UserSchemaAttributeEnum> oneOf) {
        this.oneOf = JsonNullable.of(oneOf);
    }

    public LogStreamSchema pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For `string` log stream schema property type, specifies the regular expression used to validate the property")
    @JsonProperty(value="pattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty(value="pattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public LogStreamSchema properties(Object properties) {
        this.properties = properties;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="log stream schema properties object")
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public LogStreamSchema required(List<String> required) {
        this.required = required;
        return this;
    }

    public LogStreamSchema addrequiredItem(String requiredItem) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(requiredItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required properties for this log stream schema object")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(List<String> required) {
        this.required = required;
    }

    public LogStreamSchema title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the log streaming integration")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    @Nullable
    @ApiModelProperty(value="Type of log stream schema property")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public LogStreamSchema links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogStreamSchema logStreamSchema = (LogStreamSchema)o;
        return Objects.equals(this.$schema, logStreamSchema.$schema) && Objects.equals(this.errorMessage, logStreamSchema.errorMessage) && Objects.equals(this.id, logStreamSchema.id) && LogStreamSchema.equalsNullable(this.oneOf, logStreamSchema.oneOf) && Objects.equals(this.pattern, logStreamSchema.pattern) && Objects.equals(this.properties, logStreamSchema.properties) && Objects.equals(this.required, logStreamSchema.required) && Objects.equals(this.title, logStreamSchema.title) && Objects.equals(this.type, logStreamSchema.type) && Objects.equals(this.links, logStreamSchema.links);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.$schema, this.errorMessage, this.id, LogStreamSchema.hashCodeNullable(this.oneOf), this.pattern, this.properties, this.required, this.title, this.type, this.links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamSchema {\n");
        sb.append("    $schema: ").append(this.toIndentedString(this.$schema)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    oneOf: ").append(this.toIndentedString(this.oneOf)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

