/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"reason", "result"})
public class LogOutcome
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_RESULT = "result";
    private ResultEnum result;

    @Nullable
    @ApiModelProperty(value="Reason for the result, for example, `INVALID_CREDENTIALS`")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @Nullable
    @ApiModelProperty(value="Result of the action")
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultEnum getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogOutcome logOutcome = (LogOutcome)o;
        return Objects.equals(this.reason, logOutcome.reason) && Objects.equals((Object)this.result, (Object)logOutcome.result);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.result});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogOutcome {\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResultEnum {
        SUCCESS(String.valueOf("SUCCESS")),
        FAILURE(String.valueOf("FAILURE")),
        SKIPPED(String.valueOf("SKIPPED")),
        ALLOW(String.valueOf("ALLOW")),
        DENY(String.valueOf("DENY")),
        CHALLENGE(String.valueOf("CHALLENGE")),
        UNKNOWN(String.valueOf("UNKNOWN")),
        RATE_LIMIT(String.valueOf("RATE_LIMIT")),
        DEFERRED(String.valueOf("DEFERRED")),
        SCHEDULED(String.valueOf("SCHEDULED")),
        ABANDONED(String.valueOf("ABANDONED")),
        UNANSWERED(String.valueOf("UNANSWERED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ResultEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultEnum fromValue(String value) {
            for (ResultEnum b : ResultEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

