/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LogDiskEncryptionType;
import com.okta.sdk.resource.model.LogScreenLockType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The entity that describes a device enrolled with passwordless authentication using Okta Verify.")
@JsonPropertyOrder(value={"device_integrator", "disk_encryption_type", "id", "jailbreak", "managed", "name", "os_platform", "os_version", "registered", "screen_lock_type", "secure_hardware_present"})
public class LogDevice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DEVICE_INTEGRATOR = "device_integrator";
    private Object deviceIntegrator;
    public static final String JSON_PROPERTY_DISK_ENCRYPTION_TYPE = "disk_encryption_type";
    private LogDiskEncryptionType diskEncryptionType;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_JAILBREAK = "jailbreak";
    private Boolean jailbreak;
    public static final String JSON_PROPERTY_MANAGED = "managed";
    private Boolean managed;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OS_PLATFORM = "os_platform";
    private String osPlatform;
    public static final String JSON_PROPERTY_OS_VERSION = "os_version";
    private String osVersion;
    public static final String JSON_PROPERTY_REGISTERED = "registered";
    private Boolean registered;
    public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screen_lock_type";
    private LogScreenLockType screenLockType;
    public static final String JSON_PROPERTY_SECURE_HARDWARE_PRESENT = "secure_hardware_present";
    private Boolean secureHardwarePresent;

    @Nullable
    @ApiModelProperty(value="The integration platform or software used with the device")
    @JsonProperty(value="device_integrator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getDeviceIntegrator() {
        return this.deviceIntegrator;
    }

    public LogDevice diskEncryptionType(LogDiskEncryptionType diskEncryptionType) {
        this.diskEncryptionType = diskEncryptionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="disk_encryption_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogDiskEncryptionType getDiskEncryptionType() {
        return this.diskEncryptionType;
    }

    @JsonProperty(value="disk_encryption_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncryptionType(LogDiskEncryptionType diskEncryptionType) {
        this.diskEncryptionType = diskEncryptionType;
    }

    @Nullable
    @ApiModelProperty(value="ID of the device")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="If the device has removed software restrictions")
    @JsonProperty(value="jailbreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getJailbreak() {
        return this.jailbreak;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the device is configured for device management and is registered with Okta")
    @JsonProperty(value="managed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getManaged() {
        return this.managed;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="os_platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOsPlatform() {
        return this.osPlatform;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="os_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOsVersion() {
        return this.osVersion;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the device is registered with an Okta org and is bound to an Okta Verify instance on the device")
    @JsonProperty(value="registered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRegistered() {
        return this.registered;
    }

    public LogDevice screenLockType(LogScreenLockType screenLockType) {
        this.screenLockType = screenLockType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="screen_lock_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogScreenLockType getScreenLockType() {
        return this.screenLockType;
    }

    @JsonProperty(value="screen_lock_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockType(LogScreenLockType screenLockType) {
        this.screenLockType = screenLockType;
    }

    @Nullable
    @ApiModelProperty(value="The availability of hardware security on the device")
    @JsonProperty(value="secure_hardware_present")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSecureHardwarePresent() {
        return this.secureHardwarePresent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogDevice logDevice = (LogDevice)o;
        return Objects.equals(this.deviceIntegrator, logDevice.deviceIntegrator) && Objects.equals((Object)this.diskEncryptionType, (Object)logDevice.diskEncryptionType) && Objects.equals(this.id, logDevice.id) && Objects.equals(this.jailbreak, logDevice.jailbreak) && Objects.equals(this.managed, logDevice.managed) && Objects.equals(this.name, logDevice.name) && Objects.equals(this.osPlatform, logDevice.osPlatform) && Objects.equals(this.osVersion, logDevice.osVersion) && Objects.equals(this.registered, logDevice.registered) && Objects.equals((Object)this.screenLockType, (Object)logDevice.screenLockType) && Objects.equals(this.secureHardwarePresent, logDevice.secureHardwarePresent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceIntegrator, this.diskEncryptionType, this.id, this.jailbreak, this.managed, this.name, this.osPlatform, this.osVersion, this.registered, this.screenLockType, this.secureHardwarePresent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogDevice {\n");
        sb.append("    deviceIntegrator: ").append(this.toIndentedString(this.deviceIntegrator)).append("\n");
        sb.append("    diskEncryptionType: ").append(this.toIndentedString((Object)this.diskEncryptionType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    jailbreak: ").append(this.toIndentedString(this.jailbreak)).append("\n");
        sb.append("    managed: ").append(this.toIndentedString(this.managed)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    osPlatform: ").append(this.toIndentedString(this.osPlatform)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    registered: ").append(this.toIndentedString(this.registered)).append("\n");
        sb.append("    screenLockType: ").append(this.toIndentedString((Object)this.screenLockType)).append("\n");
        sb.append("    secureHardwarePresent: ").append(this.toIndentedString(this.secureHardwarePresent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

