/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.InlineHookChannelConfigHeaders;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Properties of the communications channel that are used to contact your external service")
@JsonPropertyOrder(value={"headers", "method", "uri"})
public class InlineHookChannelConfigCreate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private List<InlineHookChannelConfigHeaders> headers = null;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri;

    public InlineHookChannelConfigCreate headers(List<InlineHookChannelConfigHeaders> headers) {
        this.headers = headers;
        return this;
    }

    public InlineHookChannelConfigCreate addheadersItem(InlineHookChannelConfigHeaders headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<InlineHookChannelConfigHeaders>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional list of key/value pairs for headers that you can send with the request to the external service.")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InlineHookChannelConfigHeaders> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(List<InlineHookChannelConfigHeaders> headers) {
        this.headers = headers;
    }

    public InlineHookChannelConfigCreate method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The method of the Okta inline hook request")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    public InlineHookChannelConfigCreate uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external service endpoint that executes the inline hook handler. It must begin with `https://` and be reachable by Okta. No white space is allowed in the URI.")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineHookChannelConfigCreate inlineHookChannelConfigCreate = (InlineHookChannelConfigCreate)o;
        return Objects.equals(this.headers, inlineHookChannelConfigCreate.headers) && Objects.equals(this.method, inlineHookChannelConfigCreate.method) && Objects.equals(this.uri, inlineHookChannelConfigCreate.uri);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.method, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineHookChannelConfigCreate {\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

