/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"cloudEventVersion", "contentType", "eventId", "eventTime", "eventTypeVersion"})
public class InlineHookBasePayload
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLOUD_EVENT_VERSION = "cloudEventVersion";
    private String cloudEventVersion;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private String contentType;
    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private String eventId;
    public static final String JSON_PROPERTY_EVENT_TIME = "eventTime";
    private String eventTime;
    public static final String JSON_PROPERTY_EVENT_TYPE_VERSION = "eventTypeVersion";
    private String eventTypeVersion;

    public InlineHookBasePayload cloudEventVersion(String cloudEventVersion) {
        this.cloudEventVersion = cloudEventVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The inline hook cloud version")
    @JsonProperty(value="cloudEventVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloudEventVersion() {
        return this.cloudEventVersion;
    }

    @JsonProperty(value="cloudEventVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloudEventVersion(String cloudEventVersion) {
        this.cloudEventVersion = cloudEventVersion;
    }

    public InlineHookBasePayload contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="application/JSON", value="The inline hook request header content")
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public InlineHookBasePayload eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3o9jBzq1SmOGmmsDsqyyeQ", value="The individual inline hook request ID")
    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public InlineHookBasePayload eventTime(String eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-01-17T21:23:56.000Z", value="The time the inline hook request was sent")
    @JsonProperty(value="eventTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventTime() {
        return this.eventTime;
    }

    @JsonProperty(value="eventTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public InlineHookBasePayload eventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The inline hook version")
    @JsonProperty(value="eventTypeVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventTypeVersion() {
        return this.eventTypeVersion;
    }

    @JsonProperty(value="eventTypeVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineHookBasePayload inlineHookBasePayload = (InlineHookBasePayload)o;
        return Objects.equals(this.cloudEventVersion, inlineHookBasePayload.cloudEventVersion) && Objects.equals(this.contentType, inlineHookBasePayload.contentType) && Objects.equals(this.eventId, inlineHookBasePayload.eventId) && Objects.equals(this.eventTime, inlineHookBasePayload.eventTime) && Objects.equals(this.eventTypeVersion, inlineHookBasePayload.eventTypeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.cloudEventVersion, this.contentType, this.eventId, this.eventTime, this.eventTypeVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineHookBasePayload {\n");
        sb.append("    cloudEventVersion: ").append(this.toIndentedString(this.cloudEventVersion)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventTypeVersion: ").append(this.toIndentedString(this.eventTypeVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

