/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Determines the Okta username for the imported user")
@JsonPropertyOrder(value={"userNameExpression", "usernameFormat"})
public class ImportUsernameObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_USER_NAME_EXPRESSION = "userNameExpression";
    private String userNameExpression;
    public static final String JSON_PROPERTY_USERNAME_FORMAT = "usernameFormat";
    private UsernameFormatEnum usernameFormat = UsernameFormatEnum.EMAIL;

    public ImportUsernameObject userNameExpression(String userNameExpression) {
        this.userNameExpression = userNameExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For `usernameFormat=CUSTOM`, specifies the Okta Expression Language statement for a username format that imported users use to sign in to Okta")
    @JsonProperty(value="userNameExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserNameExpression() {
        return this.userNameExpression;
    }

    @JsonProperty(value="userNameExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameExpression(String userNameExpression) {
        this.userNameExpression = userNameExpression;
    }

    public ImportUsernameObject usernameFormat(UsernameFormatEnum usernameFormat) {
        this.usernameFormat = usernameFormat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines the username format when users sign in to Okta")
    @JsonProperty(value="usernameFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UsernameFormatEnum getUsernameFormat() {
        return this.usernameFormat;
    }

    @JsonProperty(value="usernameFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsernameFormat(UsernameFormatEnum usernameFormat) {
        this.usernameFormat = usernameFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportUsernameObject importUsernameObject = (ImportUsernameObject)o;
        return Objects.equals(this.userNameExpression, importUsernameObject.userNameExpression) && Objects.equals((Object)this.usernameFormat, (Object)importUsernameObject.usernameFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userNameExpression, this.usernameFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportUsernameObject {\n");
        sb.append("    userNameExpression: ").append(this.toIndentedString(this.userNameExpression)).append("\n");
        sb.append("    usernameFormat: ").append(this.toIndentedString((Object)this.usernameFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UsernameFormatEnum {
        EMAIL(String.valueOf("EMAIL")),
        CUSTOM(String.valueOf("CUSTOM")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UsernameFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UsernameFormatEnum fromValue(String value) {
            for (UsernameFormatEnum b : UsernameFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

