/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Contains a set of external user attributes and their values that are mapped to Okta standard and custom profile properties. See the [`profile` object](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c=200&path=profile&t=response) and Declaration of a Custom Identity Source Schema in [Using anything as a source](https://help.okta.com/okta_help.htm?type=oie&id=ext-anything-as-a-source). > **Note:** Profile attributes can only be of the string type.")
@JsonPropertyOrder(value={"email", "firstName", "homeAddress", "lastName", "mobilePhone", "secondEmail", "userName"})
public class IdentitySourceUserProfileForUpsert
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private JsonNullable<String> firstName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HOME_ADDRESS = "homeAddress";
    private JsonNullable<String> homeAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private JsonNullable<String> lastName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
    private JsonNullable<String> mobilePhone = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SECOND_EMAIL = "secondEmail";
    private String secondEmail;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public IdentitySourceUserProfileForUpsert email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email address of the user")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public IdentitySourceUserProfileForUpsert firstName(String firstName) {
        this.firstName = JsonNullable.of((Object)firstName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="First name of the user")
    @JsonIgnore
    public String getFirstName() {
        return (String)this.firstName.orElse(null);
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFirstName_JsonNullable() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName_JsonNullable(JsonNullable<String> firstName) {
        this.firstName = firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = JsonNullable.of((Object)firstName);
    }

    public IdentitySourceUserProfileForUpsert homeAddress(String homeAddress) {
        this.homeAddress = JsonNullable.of((Object)homeAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Home address of the user")
    @JsonIgnore
    public String getHomeAddress() {
        return (String)this.homeAddress.orElse(null);
    }

    @JsonProperty(value="homeAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHomeAddress_JsonNullable() {
        return this.homeAddress;
    }

    @JsonProperty(value="homeAddress")
    public void setHomeAddress_JsonNullable(JsonNullable<String> homeAddress) {
        this.homeAddress = homeAddress;
    }

    public void setHomeAddress(String homeAddress) {
        this.homeAddress = JsonNullable.of((Object)homeAddress);
    }

    public IdentitySourceUserProfileForUpsert lastName(String lastName) {
        this.lastName = JsonNullable.of((Object)lastName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last name of the user")
    @JsonIgnore
    public String getLastName() {
        return (String)this.lastName.orElse(null);
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastName_JsonNullable() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    public void setLastName_JsonNullable(JsonNullable<String> lastName) {
        this.lastName = lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = JsonNullable.of((Object)lastName);
    }

    public IdentitySourceUserProfileForUpsert mobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.of((Object)mobilePhone);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mobile phone number of the user")
    @JsonIgnore
    public String getMobilePhone() {
        return (String)this.mobilePhone.orElse(null);
    }

    @JsonProperty(value="mobilePhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getMobilePhone_JsonNullable() {
        return this.mobilePhone;
    }

    @JsonProperty(value="mobilePhone")
    public void setMobilePhone_JsonNullable(JsonNullable<String> mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.of((Object)mobilePhone);
    }

    public IdentitySourceUserProfileForUpsert secondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Alternative email address of the user")
    @JsonProperty(value="secondEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecondEmail() {
        return this.secondEmail;
    }

    @JsonProperty(value="secondEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
    }

    public IdentitySourceUserProfileForUpsert userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Username of the user")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentitySourceUserProfileForUpsert identitySourceUserProfileForUpsert = (IdentitySourceUserProfileForUpsert)o;
        return Objects.equals(this.email, identitySourceUserProfileForUpsert.email) && IdentitySourceUserProfileForUpsert.equalsNullable(this.firstName, identitySourceUserProfileForUpsert.firstName) && IdentitySourceUserProfileForUpsert.equalsNullable(this.homeAddress, identitySourceUserProfileForUpsert.homeAddress) && IdentitySourceUserProfileForUpsert.equalsNullable(this.lastName, identitySourceUserProfileForUpsert.lastName) && IdentitySourceUserProfileForUpsert.equalsNullable(this.mobilePhone, identitySourceUserProfileForUpsert.mobilePhone) && Objects.equals(this.secondEmail, identitySourceUserProfileForUpsert.secondEmail) && Objects.equals(this.userName, identitySourceUserProfileForUpsert.userName);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.email, IdentitySourceUserProfileForUpsert.hashCodeNullable(this.firstName), IdentitySourceUserProfileForUpsert.hashCodeNullable(this.homeAddress), IdentitySourceUserProfileForUpsert.hashCodeNullable(this.lastName), IdentitySourceUserProfileForUpsert.hashCodeNullable(this.mobilePhone), this.secondEmail, this.userName);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentitySourceUserProfileForUpsert {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    homeAddress: ").append(this.toIndentedString(this.homeAddress)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    mobilePhone: ").append(this.toIndentedString(this.mobilePhone)).append("\n");
        sb.append("    secondEmail: ").append(this.toIndentedString(this.secondEmail)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

