/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Contains a set of external group attributes and their values that are mapped to Okta standard properties. See the group [`profile` object](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/#tag/Group/operation/getGroup!c=200&path=profile&t=response) and Declaration of a Custom Identity Source Schema in [Using anything as a source](https://help.okta.com/okta_help.htm?type=oie&id=ext-anything-as-a-source). > **Note:** Profile attributes can only be of the string type.")
@JsonPropertyOrder(value={"description", "displayName"})
public class IdentitySourceGroupProfileForUpsert
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public IdentitySourceGroupProfileForUpsert description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the group")
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public IdentitySourceGroupProfileForUpsert displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the group")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentitySourceGroupProfileForUpsert identitySourceGroupProfileForUpsert = (IdentitySourceGroupProfileForUpsert)o;
        return IdentitySourceGroupProfileForUpsert.equalsNullable(this.description, identitySourceGroupProfileForUpsert.description) && Objects.equals(this.displayName, identitySourceGroupProfileForUpsert.displayName);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(IdentitySourceGroupProfileForUpsert.hashCodeNullable(this.description), this.displayName);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentitySourceGroupProfileForUpsert {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

