/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IDVCredentials;
import com.okta.sdk.resource.model.IDVEndpoints;
import com.okta.sdk.resource.model.OidcAlgorithms;
import com.okta.sdk.resource.model.OidcSettings;
import com.okta.sdk.resource.model.SamlRelayState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IdP-specific protocol settings for endpoints, bindings, and algorithms used to connect with the IdP and validate messages")
@JsonPropertyOrder(value={"algorithms", "credentials", "endpoints", "relayState", "settings", "type", "scopes", "oktaIdpOrgUrl"})
@JsonTypeName(value="IdentityProvider_protocol")
public class IdentityProviderProtocol
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private OidcAlgorithms algorithms;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private IDVCredentials credentials;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private IDVEndpoints endpoints;
    public static final String JSON_PROPERTY_RELAY_STATE = "relayState";
    private SamlRelayState relayState;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private OidcSettings settings;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_OKTA_IDP_ORG_URL = "oktaIdpOrgUrl";
    private String oktaIdpOrgUrl;

    public IdentityProviderProtocol algorithms(OidcAlgorithms algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OidcAlgorithms getAlgorithms() {
        return this.algorithms;
    }

    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(OidcAlgorithms algorithms) {
        this.algorithms = algorithms;
    }

    public IdentityProviderProtocol credentials(IDVCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IDVCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(IDVCredentials credentials) {
        this.credentials = credentials;
    }

    public IdentityProviderProtocol endpoints(IDVEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IDVEndpoints getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(IDVEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public IdentityProviderProtocol relayState(SamlRelayState relayState) {
        this.relayState = relayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlRelayState getRelayState() {
        return this.relayState;
    }

    @JsonProperty(value="relayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelayState(SamlRelayState relayState) {
        this.relayState = relayState;
    }

    public IdentityProviderProtocol settings(OidcSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OidcSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(OidcSettings settings) {
        this.settings = settings;
    }

    public IdentityProviderProtocol type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SAML 2.0 protocol")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public IdentityProviderProtocol scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public IdentityProviderProtocol addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IdP-defined permission bundles to request delegated access from the user. > **Note:** The [identity provider type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request) table lists the scopes that are supported for each IdP.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public IdentityProviderProtocol oktaIdpOrgUrl(String oktaIdpOrgUrl) {
        this.oktaIdpOrgUrl = oktaIdpOrgUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://idp.example.com", value="URL of the IdP org")
    @JsonProperty(value="oktaIdpOrgUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOktaIdpOrgUrl() {
        return this.oktaIdpOrgUrl;
    }

    @JsonProperty(value="oktaIdpOrgUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOktaIdpOrgUrl(String oktaIdpOrgUrl) {
        this.oktaIdpOrgUrl = oktaIdpOrgUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderProtocol identityProviderProtocol = (IdentityProviderProtocol)o;
        return Objects.equals(this.algorithms, identityProviderProtocol.algorithms) && Objects.equals(this.credentials, identityProviderProtocol.credentials) && Objects.equals(this.endpoints, identityProviderProtocol.endpoints) && Objects.equals(this.relayState, identityProviderProtocol.relayState) && Objects.equals(this.settings, identityProviderProtocol.settings) && Objects.equals((Object)this.type, (Object)identityProviderProtocol.type) && Objects.equals(this.scopes, identityProviderProtocol.scopes) && Objects.equals(this.oktaIdpOrgUrl, identityProviderProtocol.oktaIdpOrgUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithms, this.credentials, this.endpoints, this.relayState, this.settings, this.type, this.scopes, this.oktaIdpOrgUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderProtocol {\n");
        sb.append("    algorithms: ").append(this.toIndentedString(this.algorithms)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    relayState: ").append(this.toIndentedString(this.relayState)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    oktaIdpOrgUrl: ").append(this.toIndentedString(this.oktaIdpOrgUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SAML2(String.valueOf("SAML2")),
        OAUTH2(String.valueOf("OAUTH2")),
        OIDC(String.valueOf("OIDC")),
        MTLS(String.valueOf("MTLS")),
        ID_PROOFING(String.valueOf("ID_PROOFING")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

