/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityProviderPropertiesIdvMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The properties in the IdP `properties` object vary depending on the IdP type")
@JsonPropertyOrder(value={"aalValue", "additionalAmr", "ialValue", "idvMetadata", "inquiryTemplateId"})
public class IdentityProviderProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AAL_VALUE = "aalValue";
    private JsonNullable<String> aalValue = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ADDITIONAL_AMR = "additionalAmr";
    private JsonNullable<List<AdditionalAmrEnum>> additionalAmr = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IAL_VALUE = "ialValue";
    private JsonNullable<String> ialValue = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IDV_METADATA = "idvMetadata";
    private IdentityProviderPropertiesIdvMetadata idvMetadata;
    public static final String JSON_PROPERTY_INQUIRY_TEMPLATE_ID = "inquiryTemplateId";
    private String inquiryTemplateId;

    public IdentityProviderProperties aalValue(String aalValue) {
        this.aalValue = JsonNullable.of((Object)aalValue);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The [authentication assurance level](https://developers.login.gov/oidc/#aal-values) (AAL) value for the Login.gov IdP. See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to `LOGINGOV` and `LOGINGOV_SANDBOX` IdP types.")
    @JsonIgnore
    public String getAalValue() {
        return (String)this.aalValue.orElse(null);
    }

    @JsonProperty(value="aalValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAalValue_JsonNullable() {
        return this.aalValue;
    }

    @JsonProperty(value="aalValue")
    public void setAalValue_JsonNullable(JsonNullable<String> aalValue) {
        this.aalValue = aalValue;
    }

    public void setAalValue(String aalValue) {
        this.aalValue = JsonNullable.of((Object)aalValue);
    }

    public IdentityProviderProperties additionalAmr(List<AdditionalAmrEnum> additionalAmr) {
        this.additionalAmr = JsonNullable.of(additionalAmr);
        return this;
    }

    public IdentityProviderProperties addadditionalAmrItem(AdditionalAmrEnum additionalAmrItem) {
        if (this.additionalAmr == null || !this.additionalAmr.isPresent()) {
            this.additionalAmr = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.additionalAmr.get()).add(additionalAmrItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The additional Assurance Methods References (AMR) values for Smart Card IdPs. Applies to `X509` IdP type.")
    @JsonIgnore
    public List<AdditionalAmrEnum> getAdditionalAmr() {
        return (List)this.additionalAmr.orElse(null);
    }

    @JsonProperty(value="additionalAmr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<AdditionalAmrEnum>> getAdditionalAmr_JsonNullable() {
        return this.additionalAmr;
    }

    @JsonProperty(value="additionalAmr")
    public void setAdditionalAmr_JsonNullable(JsonNullable<List<AdditionalAmrEnum>> additionalAmr) {
        this.additionalAmr = additionalAmr;
    }

    public void setAdditionalAmr(List<AdditionalAmrEnum> additionalAmr) {
        this.additionalAmr = JsonNullable.of(additionalAmr);
    }

    public IdentityProviderProperties ialValue(String ialValue) {
        this.ialValue = JsonNullable.of((Object)ialValue);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The [type of identity verification](https://developers.login.gov/oidc/#ial-values) (IAL) value for the Login.gov IdP. See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to `LOGINGOV` and `LOGINGOV_SANDBOX` IdP types.")
    @JsonIgnore
    public String getIalValue() {
        return (String)this.ialValue.orElse(null);
    }

    @JsonProperty(value="ialValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIalValue_JsonNullable() {
        return this.ialValue;
    }

    @JsonProperty(value="ialValue")
    public void setIalValue_JsonNullable(JsonNullable<String> ialValue) {
        this.ialValue = ialValue;
    }

    public void setIalValue(String ialValue) {
        this.ialValue = JsonNullable.of((Object)ialValue);
    }

    public IdentityProviderProperties idvMetadata(IdentityProviderPropertiesIdvMetadata idvMetadata) {
        this.idvMetadata = idvMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="idvMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentityProviderPropertiesIdvMetadata getIdvMetadata() {
        return this.idvMetadata;
    }

    @JsonProperty(value="idvMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdvMetadata(IdentityProviderPropertiesIdvMetadata idvMetadata) {
        this.idvMetadata = idvMetadata;
    }

    public IdentityProviderProperties inquiryTemplateId(String inquiryTemplateId) {
        this.inquiryTemplateId = inquiryTemplateId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="itmpl_HSctx8fNvXoHtrQfz2hxUVH8RBjG", required=true, value="The ID of the inquiry template from your Persona dashboard. The inquiry template always starts with `itmpl`. Applies to the `IDV_PERSONA` IdP type.")
    @JsonProperty(value="inquiryTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInquiryTemplateId() {
        return this.inquiryTemplateId;
    }

    @JsonProperty(value="inquiryTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInquiryTemplateId(String inquiryTemplateId) {
        this.inquiryTemplateId = inquiryTemplateId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderProperties identityProviderProperties = (IdentityProviderProperties)o;
        return IdentityProviderProperties.equalsNullable(this.aalValue, identityProviderProperties.aalValue) && IdentityProviderProperties.equalsNullable(this.additionalAmr, identityProviderProperties.additionalAmr) && IdentityProviderProperties.equalsNullable(this.ialValue, identityProviderProperties.ialValue) && Objects.equals(this.idvMetadata, identityProviderProperties.idvMetadata) && Objects.equals(this.inquiryTemplateId, identityProviderProperties.inquiryTemplateId);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(IdentityProviderProperties.hashCodeNullable(this.aalValue), IdentityProviderProperties.hashCodeNullable(this.additionalAmr), IdentityProviderProperties.hashCodeNullable(this.ialValue), this.idvMetadata, this.inquiryTemplateId);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderProperties {\n");
        sb.append("    aalValue: ").append(this.toIndentedString(this.aalValue)).append("\n");
        sb.append("    additionalAmr: ").append(this.toIndentedString(this.additionalAmr)).append("\n");
        sb.append("    ialValue: ").append(this.toIndentedString(this.ialValue)).append("\n");
        sb.append("    idvMetadata: ").append(this.toIndentedString(this.idvMetadata)).append("\n");
        sb.append("    inquiryTemplateId: ").append(this.toIndentedString(this.inquiryTemplateId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AdditionalAmrEnum {
        SC(String.valueOf("sc")),
        HWK(String.valueOf("hwk")),
        PIN(String.valueOf("pin")),
        MFA(String.valueOf("mfa")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private AdditionalAmrEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdditionalAmrEnum fromValue(String value) {
            for (AdditionalAmrEnum b : AdditionalAmrEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

