/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityAssertionCustomASConnectionCreatableAuthorizationServer;
import com.okta.sdk.resource.model.ScopeCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Create an identity assertion connection for a custom authorization server")
@JsonPropertyOrder(value={"authorizationServer", "connectionType", "protocolType", "scopeCondition", "scopes"})
public class IdentityAssertionCustomASConnectionCreatable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION_SERVER = "authorizationServer";
    private IdentityAssertionCustomASConnectionCreatableAuthorizationServer authorizationServer;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    private ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_SCOPE_CONDITION = "scopeCondition";
    private ScopeCondition scopeCondition;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = new ArrayList<String>();

    public IdentityAssertionCustomASConnectionCreatable authorizationServer(IdentityAssertionCustomASConnectionCreatableAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentityAssertionCustomASConnectionCreatableAuthorizationServer getAuthorizationServer() {
        return this.authorizationServer;
    }

    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizationServer(IdentityAssertionCustomASConnectionCreatableAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    public IdentityAssertionCustomASConnectionCreatable connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public IdentityAssertionCustomASConnectionCreatable protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public IdentityAssertionCustomASConnectionCreatable scopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScopeCondition getScopeCondition() {
        return this.scopeCondition;
    }

    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
    }

    public IdentityAssertionCustomASConnectionCreatable scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public IdentityAssertionCustomASConnectionCreatable addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of scopes. Required for all `scopeCondition` values. For `ALL_SCOPES`, this array is required with a single value of `*`. For `INCLUDE_ONLY`, only these scopes are allowed. For `EXCLUDE`, all scopes except these are allowed.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityAssertionCustomASConnectionCreatable identityAssertionCustomASConnectionCreatable = (IdentityAssertionCustomASConnectionCreatable)o;
        return Objects.equals(this.authorizationServer, identityAssertionCustomASConnectionCreatable.authorizationServer) && Objects.equals((Object)this.connectionType, (Object)identityAssertionCustomASConnectionCreatable.connectionType) && Objects.equals((Object)this.protocolType, (Object)identityAssertionCustomASConnectionCreatable.protocolType) && Objects.equals((Object)this.scopeCondition, (Object)identityAssertionCustomASConnectionCreatable.scopeCondition) && Objects.equals(this.scopes, identityAssertionCustomASConnectionCreatable.scopes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationServer, this.connectionType, this.protocolType, this.scopeCondition, this.scopes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityAssertionCustomASConnectionCreatable {\n");
        sb.append("    authorizationServer: ").append(this.toIndentedString(this.authorizationServer)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    scopeCondition: ").append(this.toIndentedString((Object)this.scopeCondition)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        IDENTITY_ASSERTION_CUSTOM_AS(String.valueOf("IDENTITY_ASSERTION_CUSTOM_AS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        IDENTITY_ASSERTION(String.valueOf("IDENTITY_ASSERTION")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

