/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.IDVAuthorizationEndpoint;
import com.okta.sdk.resource.model.IDVParEndpoint;
import com.okta.sdk.resource.model.IDVTokenEndpoint;
import com.okta.sdk.resource.model.OidcJwksEndpoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Contains endpoints for the IDV vendor. When you create an `IDV_STANDARD` IdP, you must include the `par`, `authorization`, `token`, and `jwks` endpoints in the request body.")
@JsonPropertyOrder(value={"authorization", "jwks", "par", "token"})
public class IDVEndpoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION = "authorization";
    private IDVAuthorizationEndpoint authorization;
    public static final String JSON_PROPERTY_JWKS = "jwks";
    private OidcJwksEndpoint jwks;
    public static final String JSON_PROPERTY_PAR = "par";
    private IDVParEndpoint par;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private IDVTokenEndpoint token;

    public IDVEndpoints authorization(IDVAuthorizationEndpoint authorization) {
        this.authorization = authorization;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="authorization")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IDVAuthorizationEndpoint getAuthorization() {
        return this.authorization;
    }

    @JsonProperty(value="authorization")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorization(IDVAuthorizationEndpoint authorization) {
        this.authorization = authorization;
    }

    public IDVEndpoints jwks(OidcJwksEndpoint jwks) {
        this.jwks = jwks;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OidcJwksEndpoint getJwks() {
        return this.jwks;
    }

    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwks(OidcJwksEndpoint jwks) {
        this.jwks = jwks;
    }

    public IDVEndpoints par(IDVParEndpoint par) {
        this.par = par;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="par")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IDVParEndpoint getPar() {
        return this.par;
    }

    @JsonProperty(value="par")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPar(IDVParEndpoint par) {
        this.par = par;
    }

    public IDVEndpoints token(IDVTokenEndpoint token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IDVTokenEndpoint getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setToken(IDVTokenEndpoint token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDVEndpoints idVEndpoints = (IDVEndpoints)o;
        return Objects.equals(this.authorization, idVEndpoints.authorization) && Objects.equals(this.jwks, idVEndpoints.jwks) && Objects.equals(this.par, idVEndpoints.par) && Objects.equals(this.token, idVEndpoints.token);
    }

    public int hashCode() {
        return Objects.hash(this.authorization, this.jwks, this.par, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IDVEndpoints {\n");
        sb.append("    authorization: ").append(this.toIndentedString(this.authorization)).append("\n");
        sb.append("    jwks: ").append(this.toIndentedString(this.jwks)).append("\n");
        sb.append("    par: ").append(this.toIndentedString(this.par)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

