/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An entitlement in a governance bundle")
@JsonPropertyOrder(value={"resourceSets", "role", "targets"})
public class IAMBundleEntitlement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RESOURCE_SETS = "resourceSets";
    private List<String> resourceSets = null;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_TARGETS = "targets";
    private List<String> targets = null;

    public IAMBundleEntitlement resourceSets(List<String> resourceSets) {
        this.resourceSets = resourceSets;
        return this;
    }

    public IAMBundleEntitlement addresourceSetsItem(String resourceSetsItem) {
        if (this.resourceSets == null) {
            this.resourceSets = new ArrayList<String>();
        }
        this.resourceSets.add(resourceSetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of resource set IDs for the custom role")
    @JsonProperty(value="resourceSets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getResourceSets() {
        return this.resourceSets;
    }

    @JsonProperty(value="resourceSets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceSets(List<String> resourceSets) {
        this.resourceSets = resourceSets;
    }

    public IAMBundleEntitlement role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The role")
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(String role) {
        this.role = role;
    }

    public IAMBundleEntitlement targets(List<String> targets) {
        this.targets = targets;
        return this;
    }

    public IAMBundleEntitlement addtargetsItem(String targetsItem) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(targetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of target resource IDs to scope the entitlement with the role")
    @JsonProperty(value="targets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTargets() {
        return this.targets;
    }

    @JsonProperty(value="targets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargets(List<String> targets) {
        this.targets = targets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IAMBundleEntitlement iaMBundleEntitlement = (IAMBundleEntitlement)o;
        return Objects.equals(this.resourceSets, iaMBundleEntitlement.resourceSets) && Objects.equals(this.role, iaMBundleEntitlement.role) && Objects.equals(this.targets, iaMBundleEntitlement.targets);
    }

    public int hashCode() {
        return Objects.hash(this.resourceSets, this.role, this.targets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IAMBundleEntitlement {\n");
        sb.append("    resourceSets: ").append(this.toIndentedString(this.resourceSets)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    targets: ").append(this.toIndentedString(this.targets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

