/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum GrantType {
    AUTHORIZATION_CODE("authorization_code"),
    CLIENT_CREDENTIALS("client_credentials"),
    IMPLICIT("implicit"),
    INTERACTION_CODE("interaction_code"),
    PASSWORD("password"),
    REFRESH_TOKEN("refresh_token"),
    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code"),
    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_JWT_BEARER("urn:ietf:params:oauth:grant-type:jwt-bearer"),
    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_SAML2_BEARER("urn:ietf:params:oauth:grant-type:saml2-bearer"),
    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange"),
    URN_OPENID_PARAMS_GRANT_TYPE_CIBA("urn:openid:params:grant-type:ciba"),
    URN_OKTA_PARAMS_OAUTH_GRANT_TYPE_OTP("urn:okta:params:oauth:grant-type:otp"),
    URN_OKTA_PARAMS_OAUTH_GRANT_TYPE_OOB("urn:okta:params:oauth:grant-type:oob"),
    HTTP_AUTH0_COM_OAUTH_GRANT_TYPE_MFA_OTP("http://auth0.com/oauth/grant-type/mfa-otp"),
    HTTP_AUTH0_COM_OAUTH_GRANT_TYPE_MFA_OOB("http://auth0.com/oauth/grant-type/mfa-oob"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private GrantType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static GrantType fromValue(String value) {
        for (GrantType b : GrantType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString().toString());
    }
}

