/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "expression", "id", "lastUpdated", "name"})
public class FederatedClaim
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    @Nullable
    @ApiModelProperty(example="2024-02-29T20:08:24.000Z", value="Timestamp when the federated claim was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    public FederatedClaim expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="appuser.entitlements.role", value="The Okta Expression Language expression to be evaluated at runtime")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Nullable
    @ApiModelProperty(example="ofc2f4zrZbs8nUa7p0g4", value="The unique ID of the federated claim")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp when the federated claim was updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public FederatedClaim name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="roleg", value="The name of the claim to be used in the produced token")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FederatedClaim federatedClaim = (FederatedClaim)o;
        return Objects.equals(this.created, federatedClaim.created) && Objects.equals(this.expression, federatedClaim.expression) && Objects.equals(this.id, federatedClaim.id) && Objects.equals(this.lastUpdated, federatedClaim.lastUpdated) && Objects.equals(this.name, federatedClaim.name);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.expression, this.id, this.lastUpdated, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FederatedClaim {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

