/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.EventHookChannelConfigAuthScheme;
import com.okta.sdk.resource.model.EventHookChannelConfigHeader;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authScheme", "headers", "method", "uri"})
public class EventHookChannelConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTH_SCHEME = "authScheme";
    private EventHookChannelConfigAuthScheme authScheme;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private List<EventHookChannelConfigHeader> headers = null;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri;

    public EventHookChannelConfig authScheme(EventHookChannelConfigAuthScheme authScheme) {
        this.authScheme = authScheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="authScheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventHookChannelConfigAuthScheme getAuthScheme() {
        return this.authScheme;
    }

    @JsonProperty(value="authScheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthScheme(EventHookChannelConfigAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public EventHookChannelConfig headers(List<EventHookChannelConfigHeader> headers) {
        this.headers = headers;
        return this;
    }

    public EventHookChannelConfig addheadersItem(EventHookChannelConfigHeader headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<EventHookChannelConfigHeader>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional list of key/value pairs for headers that can be sent with the request to the external service. For example, `X-Other-Header` is an example of an optional header, with a value of `my-header-value`, that you want Okta to pass to your external service.")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventHookChannelConfigHeader> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(List<EventHookChannelConfigHeader> headers) {
        this.headers = headers;
    }

    @Nullable
    @ApiModelProperty(value="The method of the Okta event hook request")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    public EventHookChannelConfig uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The external service endpoint called to execute the event hook handler")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventHookChannelConfig eventHookChannelConfig = (EventHookChannelConfig)o;
        return Objects.equals(this.authScheme, eventHookChannelConfig.authScheme) && Objects.equals(this.headers, eventHookChannelConfig.headers) && Objects.equals(this.method, eventHookChannelConfig.method) && Objects.equals(this.uri, eventHookChannelConfig.uri);
    }

    public int hashCode() {
        return Objects.hash(this.authScheme, this.headers, this.method, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHookChannelConfig {\n");
        sb.append("    authScheme: ").append(this.toIndentedString(this.authScheme)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

