/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EventHookChannel;
import com.okta.sdk.resource.model.EventHookLinks;
import com.okta.sdk.resource.model.EventHookVerificationStatus;
import com.okta.sdk.resource.model.EventSubscriptions;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"channel", "created", "createdBy", "description", "events", "id", "lastUpdated", "name", "status", "verificationStatus", "_links"})
public class EventHook
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CHANNEL = "channel";
    private EventHookChannel channel;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EVENTS = "events";
    private EventSubscriptions events;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private EventHookVerificationStatus verificationStatus;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private EventHookLinks links;

    public EventHook channel(EventHookChannel channel) {
        this.channel = channel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventHookChannel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannel(EventHookChannel channel) {
        this.channel = channel;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of the event hook creation")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the user who created the event hook")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public EventHook description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the event hook")
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public EventHook events(EventSubscriptions events) {
        this.events = events;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventSubscriptions getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEvents(EventSubscriptions events) {
        this.events = events;
    }

    @Nullable
    @ApiModelProperty(value="Unique key for the event hook")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Date of the last event hook update")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public EventHook name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Display name for the event hook")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="Status of the event hook")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public EventHook verificationStatus(EventHookVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventHookVerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(EventHookVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public EventHook links(EventHookLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventHookLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(EventHookLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventHook eventHook = (EventHook)o;
        return Objects.equals(this.channel, eventHook.channel) && Objects.equals(this.created, eventHook.created) && Objects.equals(this.createdBy, eventHook.createdBy) && EventHook.equalsNullable(this.description, eventHook.description) && Objects.equals(this.events, eventHook.events) && Objects.equals(this.id, eventHook.id) && Objects.equals(this.lastUpdated, eventHook.lastUpdated) && Objects.equals(this.name, eventHook.name) && Objects.equals((Object)this.status, (Object)eventHook.status) && Objects.equals((Object)this.verificationStatus, (Object)eventHook.verificationStatus) && Objects.equals(this.links, eventHook.links);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channel, this.created, this.createdBy, EventHook.hashCodeNullable(this.description), this.events, this.id, this.lastUpdated, this.name, this.status, this.verificationStatus, this.links});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHook {\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

