/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AppConfig;
import com.okta.sdk.resource.model.GroupPushMappingStatusUpsert;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"appConfig", "sourceGroupId", "status", "targetGroupId", "targetGroupName"})
public class CreateGroupPushMappingRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_CONFIG = "appConfig";
    private AppConfig appConfig;
    public static final String JSON_PROPERTY_SOURCE_GROUP_ID = "sourceGroupId";
    private String sourceGroupId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private GroupPushMappingStatusUpsert status = GroupPushMappingStatusUpsert.ACTIVE;
    public static final String JSON_PROPERTY_TARGET_GROUP_ID = "targetGroupId";
    private String targetGroupId;
    public static final String JSON_PROPERTY_TARGET_GROUP_NAME = "targetGroupName";
    private String targetGroupName;

    public CreateGroupPushMappingRequest appConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="appConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @JsonProperty(value="appConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public CreateGroupPushMappingRequest sourceGroupId(String sourceGroupId) {
        this.sourceGroupId = sourceGroupId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The ID of the source group for the group push mapping")
    @JsonProperty(value="sourceGroupId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceGroupId() {
        return this.sourceGroupId;
    }

    @JsonProperty(value="sourceGroupId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceGroupId(String sourceGroupId) {
        this.sourceGroupId = sourceGroupId;
    }

    public CreateGroupPushMappingRequest status(GroupPushMappingStatusUpsert status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupPushMappingStatusUpsert getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(GroupPushMappingStatusUpsert status) {
        this.status = status;
    }

    public CreateGroupPushMappingRequest targetGroupId(String targetGroupId) {
        this.targetGroupId = targetGroupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the existing target group for the group push mapping. This is used to link to an existing group. Required if `targetGroupName` is not provided.")
    @JsonProperty(value="targetGroupId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetGroupId() {
        return this.targetGroupId;
    }

    @JsonProperty(value="targetGroupId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetGroupId(String targetGroupId) {
        this.targetGroupId = targetGroupId;
    }

    public CreateGroupPushMappingRequest targetGroupName(String targetGroupName) {
        this.targetGroupName = targetGroupName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the target group for the group push mapping. This is used when creating a new downstream group. If the group already exists, it links to the existing group. Required if `targetGroupId` is not provided.")
    @JsonProperty(value="targetGroupName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetGroupName() {
        return this.targetGroupName;
    }

    @JsonProperty(value="targetGroupName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetGroupName(String targetGroupName) {
        this.targetGroupName = targetGroupName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateGroupPushMappingRequest createGroupPushMappingRequest = (CreateGroupPushMappingRequest)o;
        return Objects.equals(this.appConfig, createGroupPushMappingRequest.appConfig) && Objects.equals(this.sourceGroupId, createGroupPushMappingRequest.sourceGroupId) && Objects.equals((Object)this.status, (Object)createGroupPushMappingRequest.status) && Objects.equals(this.targetGroupId, createGroupPushMappingRequest.targetGroupId) && Objects.equals(this.targetGroupName, createGroupPushMappingRequest.targetGroupName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appConfig, this.sourceGroupId, this.status, this.targetGroupId, this.targetGroupName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateGroupPushMappingRequest {\n");
        sb.append("    appConfig: ").append(this.toIndentedString(this.appConfig)).append("\n");
        sb.append("    sourceGroupId: ").append(this.toIndentedString(this.sourceGroupId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    targetGroupId: ").append(this.toIndentedString(this.targetGroupId)).append("\n");
        sb.append("    targetGroupName: ").append(this.toIndentedString(this.targetGroupName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

